<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomer StructType
 * @subpackage Structs
 */
class UpdateCustomer extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Customer
     */
    public $customer;
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerId;
    /**
     * The customerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerInternalId;
    /**
     * Constructor method for UpdateCustomer
     * @uses UpdateCustomer::setSecurityToken()
     * @uses UpdateCustomer::setCustomer()
     * @uses UpdateCustomer::setCustomerId()
     * @uses UpdateCustomer::setCustomerInternalId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param \eBizCharge\StructType\Customer $customer
     * @param string $customerId
     * @param string $customerInternalId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, \eBizCharge\StructType\Customer $customer = null, $customerId = null, $customerInternalId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setCustomer($customer)
            ->setCustomerId($customerId)
            ->setCustomerInternalId($customerInternalId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\UpdateCustomer
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get customer value
     * @return \eBizCharge\StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \eBizCharge\StructType\Customer $customer
     * @return \eBizCharge\StructType\UpdateCustomer
     */
    public function setCustomer(\eBizCharge\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get customerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\UpdateCustomer
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get customerInternalId value
     * @return string|null
     */
    public function getCustomerInternalId()
    {
        return $this->customerInternalId;
    }
    /**
     * Set customerInternalId value
     * @param string $customerInternalId
     * @return \eBizCharge\StructType\UpdateCustomer
     */
    public function setCustomerInternalId($customerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($customerInternalId) && !is_string($customerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerInternalId, true), gettype($customerInternalId)), __LINE__);
        }
        $this->customerInternalId = $customerInternalId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\UpdateCustomer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
