<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionLineItem StructType
 * @subpackage Structs
 */
class TransactionLineItem extends AbstractStructBase
{
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DiscountAmount;
    /**
     * The DiscountRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DiscountRate;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $UnitPrice;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Qty;
    /**
     * The Taxable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Taxable;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxAmount;
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxRate;
    /**
     * The ProductRefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductRefNum;
    /**
     * The SKU
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SKU;
    /**
     * The CommodityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommodityCode;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The UnitOfMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitOfMeasure;
    /**
     * Constructor method for TransactionLineItem
     * @uses TransactionLineItem::setDiscountAmount()
     * @uses TransactionLineItem::setDiscountRate()
     * @uses TransactionLineItem::setUnitPrice()
     * @uses TransactionLineItem::setQty()
     * @uses TransactionLineItem::setTaxable()
     * @uses TransactionLineItem::setTaxAmount()
     * @uses TransactionLineItem::setTaxRate()
     * @uses TransactionLineItem::setProductRefNum()
     * @uses TransactionLineItem::setSKU()
     * @uses TransactionLineItem::setCommodityCode()
     * @uses TransactionLineItem::setProductName()
     * @uses TransactionLineItem::setDescription()
     * @uses TransactionLineItem::setUnitOfMeasure()
     * @param float $discountAmount
     * @param float $discountRate
     * @param float $unitPrice
     * @param float $qty
     * @param bool $taxable
     * @param float $taxAmount
     * @param float $taxRate
     * @param string $productRefNum
     * @param string $sKU
     * @param string $commodityCode
     * @param string $productName
     * @param string $description
     * @param string $unitOfMeasure
     */
    public function __construct($discountAmount = null, $discountRate = null, $unitPrice = null, $qty = null, $taxable = null, $taxAmount = null, $taxRate = null, $productRefNum = null, $sKU = null, $commodityCode = null, $productName = null, $description = null, $unitOfMeasure = null)
    {
        $this
            ->setDiscountAmount($discountAmount)
            ->setDiscountRate($discountRate)
            ->setUnitPrice($unitPrice)
            ->setQty($qty)
            ->setTaxable($taxable)
            ->setTaxAmount($taxAmount)
            ->setTaxRate($taxRate)
            ->setProductRefNum($productRefNum)
            ->setSKU($sKU)
            ->setCommodityCode($commodityCode)
            ->setProductName($productName)
            ->setDescription($description)
            ->setUnitOfMeasure($unitOfMeasure);
    }
    /**
     * Get DiscountAmount value
     * @return float
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param float $discountAmount
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get DiscountRate value
     * @return float
     */
    public function getDiscountRate()
    {
        return $this->DiscountRate;
    }
    /**
     * Set DiscountRate value
     * @param float $discountRate
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public function setDiscountRate($discountRate = null)
    {
        // validation for constraint: float
        if (!is_null($discountRate) && !(is_float($discountRate) || is_numeric($discountRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountRate, true), gettype($discountRate)), __LINE__);
        }
        $this->DiscountRate = $discountRate;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return float
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get Qty value
     * @return float
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param float $qty
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get Taxable value
     * @return bool
     */
    public function getTaxable()
    {
        return $this->Taxable;
    }
    /**
     * Set Taxable value
     * @param bool $taxable
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public function setTaxable($taxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxable) && !is_bool($taxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxable, true), gettype($taxable)), __LINE__);
        }
        $this->Taxable = $taxable;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TaxRate value
     * @return float
     */
    public function getTaxRate()
    {
        return $this->TaxRate;
    }
    /**
     * Set TaxRate value
     * @param float $taxRate
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate) && !(is_float($taxRate) || is_numeric($taxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->TaxRate = $taxRate;
        return $this;
    }
    /**
     * Get ProductRefNum value
     * @return string|null
     */
    public function getProductRefNum()
    {
        return $this->ProductRefNum;
    }
    /**
     * Set ProductRefNum value
     * @param string $productRefNum
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public function setProductRefNum($productRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($productRefNum) && !is_string($productRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productRefNum, true), gettype($productRefNum)), __LINE__);
        }
        $this->ProductRefNum = $productRefNum;
        return $this;
    }
    /**
     * Get SKU value
     * @return string|null
     */
    public function getSKU()
    {
        return $this->SKU;
    }
    /**
     * Set SKU value
     * @param string $sKU
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public function setSKU($sKU = null)
    {
        // validation for constraint: string
        if (!is_null($sKU) && !is_string($sKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sKU, true), gettype($sKU)), __LINE__);
        }
        $this->SKU = $sKU;
        return $this;
    }
    /**
     * Get CommodityCode value
     * @return string|null
     */
    public function getCommodityCode()
    {
        return $this->CommodityCode;
    }
    /**
     * Set CommodityCode value
     * @param string $commodityCode
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public function setCommodityCode($commodityCode = null)
    {
        // validation for constraint: string
        if (!is_null($commodityCode) && !is_string($commodityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodityCode, true), gettype($commodityCode)), __LINE__);
        }
        $this->CommodityCode = $commodityCode;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get UnitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->UnitOfMeasure;
    }
    /**
     * Set UnitOfMeasure value
     * @param string $unitOfMeasure
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasure) && !is_string($unitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasure, true), gettype($unitOfMeasure)), __LINE__);
        }
        $this->UnitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\TransactionLineItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
