<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Terms StructType
 * @subpackage Structs
 */
class Terms extends AbstractStructBase
{
    /**
     * The NetDueInDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NetDueInDays;
    /**
     * The DiscountPercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DiscountPercentage;
    /**
     * The DiscountIfPaidWithinDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DiscountIfPaidWithinDays;
    /**
     * The IsInactive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsInactive;
    /**
     * The TermsInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TermsInternalId;
    /**
     * The TermsId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TermsId;
    /**
     * The TermsName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TermsName;
    /**
     * The TermsDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TermsDescription;
    /**
     * The ExternalUniqueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalUniqueId;
    /**
     * Constructor method for Terms
     * @uses Terms::setNetDueInDays()
     * @uses Terms::setDiscountPercentage()
     * @uses Terms::setDiscountIfPaidWithinDays()
     * @uses Terms::setIsInactive()
     * @uses Terms::setTermsInternalId()
     * @uses Terms::setTermsId()
     * @uses Terms::setTermsName()
     * @uses Terms::setTermsDescription()
     * @uses Terms::setExternalUniqueId()
     * @param int $netDueInDays
     * @param float $discountPercentage
     * @param int $discountIfPaidWithinDays
     * @param bool $isInactive
     * @param string $termsInternalId
     * @param string $termsId
     * @param string $termsName
     * @param string $termsDescription
     * @param string $externalUniqueId
     */
    public function __construct($netDueInDays = null, $discountPercentage = null, $discountIfPaidWithinDays = null, $isInactive = null, $termsInternalId = null, $termsId = null, $termsName = null, $termsDescription = null, $externalUniqueId = null)
    {
        $this
            ->setNetDueInDays($netDueInDays)
            ->setDiscountPercentage($discountPercentage)
            ->setDiscountIfPaidWithinDays($discountIfPaidWithinDays)
            ->setIsInactive($isInactive)
            ->setTermsInternalId($termsInternalId)
            ->setTermsId($termsId)
            ->setTermsName($termsName)
            ->setTermsDescription($termsDescription)
            ->setExternalUniqueId($externalUniqueId);
    }
    /**
     * Get NetDueInDays value
     * @return int
     */
    public function getNetDueInDays()
    {
        return $this->NetDueInDays;
    }
    /**
     * Set NetDueInDays value
     * @param int $netDueInDays
     * @return \eBizCharge\StructType\Terms
     */
    public function setNetDueInDays($netDueInDays = null)
    {
        // validation for constraint: int
        if (!is_null($netDueInDays) && !(is_int($netDueInDays) || ctype_digit($netDueInDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($netDueInDays, true), gettype($netDueInDays)), __LINE__);
        }
        $this->NetDueInDays = $netDueInDays;
        return $this;
    }
    /**
     * Get DiscountPercentage value
     * @return float
     */
    public function getDiscountPercentage()
    {
        return $this->DiscountPercentage;
    }
    /**
     * Set DiscountPercentage value
     * @param float $discountPercentage
     * @return \eBizCharge\StructType\Terms
     */
    public function setDiscountPercentage($discountPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercentage) && !(is_float($discountPercentage) || is_numeric($discountPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercentage, true), gettype($discountPercentage)), __LINE__);
        }
        $this->DiscountPercentage = $discountPercentage;
        return $this;
    }
    /**
     * Get DiscountIfPaidWithinDays value
     * @return int
     */
    public function getDiscountIfPaidWithinDays()
    {
        return $this->DiscountIfPaidWithinDays;
    }
    /**
     * Set DiscountIfPaidWithinDays value
     * @param int $discountIfPaidWithinDays
     * @return \eBizCharge\StructType\Terms
     */
    public function setDiscountIfPaidWithinDays($discountIfPaidWithinDays = null)
    {
        // validation for constraint: int
        if (!is_null($discountIfPaidWithinDays) && !(is_int($discountIfPaidWithinDays) || ctype_digit($discountIfPaidWithinDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($discountIfPaidWithinDays, true), gettype($discountIfPaidWithinDays)), __LINE__);
        }
        $this->DiscountIfPaidWithinDays = $discountIfPaidWithinDays;
        return $this;
    }
    /**
     * Get IsInactive value
     * @return bool
     */
    public function getIsInactive()
    {
        return $this->IsInactive;
    }
    /**
     * Set IsInactive value
     * @param bool $isInactive
     * @return \eBizCharge\StructType\Terms
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->IsInactive = $isInactive;
        return $this;
    }
    /**
     * Get TermsInternalId value
     * @return string|null
     */
    public function getTermsInternalId()
    {
        return $this->TermsInternalId;
    }
    /**
     * Set TermsInternalId value
     * @param string $termsInternalId
     * @return \eBizCharge\StructType\Terms
     */
    public function setTermsInternalId($termsInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($termsInternalId) && !is_string($termsInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsInternalId, true), gettype($termsInternalId)), __LINE__);
        }
        $this->TermsInternalId = $termsInternalId;
        return $this;
    }
    /**
     * Get TermsId value
     * @return string|null
     */
    public function getTermsId()
    {
        return $this->TermsId;
    }
    /**
     * Set TermsId value
     * @param string $termsId
     * @return \eBizCharge\StructType\Terms
     */
    public function setTermsId($termsId = null)
    {
        // validation for constraint: string
        if (!is_null($termsId) && !is_string($termsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsId, true), gettype($termsId)), __LINE__);
        }
        $this->TermsId = $termsId;
        return $this;
    }
    /**
     * Get TermsName value
     * @return string|null
     */
    public function getTermsName()
    {
        return $this->TermsName;
    }
    /**
     * Set TermsName value
     * @param string $termsName
     * @return \eBizCharge\StructType\Terms
     */
    public function setTermsName($termsName = null)
    {
        // validation for constraint: string
        if (!is_null($termsName) && !is_string($termsName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsName, true), gettype($termsName)), __LINE__);
        }
        $this->TermsName = $termsName;
        return $this;
    }
    /**
     * Get TermsDescription value
     * @return string|null
     */
    public function getTermsDescription()
    {
        return $this->TermsDescription;
    }
    /**
     * Set TermsDescription value
     * @param string $termsDescription
     * @return \eBizCharge\StructType\Terms
     */
    public function setTermsDescription($termsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($termsDescription) && !is_string($termsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsDescription, true), gettype($termsDescription)), __LINE__);
        }
        $this->TermsDescription = $termsDescription;
        return $this;
    }
    /**
     * Get ExternalUniqueId value
     * @return string|null
     */
    public function getExternalUniqueId()
    {
        return $this->ExternalUniqueId;
    }
    /**
     * Set ExternalUniqueId value
     * @param string $externalUniqueId
     * @return \eBizCharge\StructType\Terms
     */
    public function setExternalUniqueId($externalUniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($externalUniqueId) && !is_string($externalUniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalUniqueId, true), gettype($externalUniqueId)), __LINE__);
        }
        $this->ExternalUniqueId = $externalUniqueId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\Terms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
