<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentRequest StructType
 * @subpackage Structs
 */
class PaymentRequest extends AbstractStructBase
{
    /**
     * The MerchantId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The SubCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubCustomerId;
    /**
     * The DivisionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DivisionId;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The InvoiceInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceInternalId;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDate;
    /**
     * The InvoiceDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDueDate;
    /**
     * The PoNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PoNum;
    /**
     * The SoNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoNum;
    /**
     * The InvoiceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceAmount;
    /**
     * The AmountDue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AmountDue;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthCode;
    /**
     * The RefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefNum;
    /**
     * The Last4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last4;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentType;
    /**
     * The DatePaid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DatePaid;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaidAmount;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeId;
    /**
     * The Software
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Software;
    /**
     * The PaymentInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentInternalId;
    /**
     * Constructor method for PaymentRequest
     * @uses PaymentRequest::setMerchantId()
     * @uses PaymentRequest::setCustomerId()
     * @uses PaymentRequest::setSubCustomerId()
     * @uses PaymentRequest::setDivisionId()
     * @uses PaymentRequest::setInvoiceNumber()
     * @uses PaymentRequest::setInvoiceInternalId()
     * @uses PaymentRequest::setInvoiceDate()
     * @uses PaymentRequest::setInvoiceDueDate()
     * @uses PaymentRequest::setPoNum()
     * @uses PaymentRequest::setSoNum()
     * @uses PaymentRequest::setInvoiceAmount()
     * @uses PaymentRequest::setAmountDue()
     * @uses PaymentRequest::setCurrency()
     * @uses PaymentRequest::setAuthCode()
     * @uses PaymentRequest::setRefNum()
     * @uses PaymentRequest::setLast4()
     * @uses PaymentRequest::setPaymentMethod()
     * @uses PaymentRequest::setPaymentType()
     * @uses PaymentRequest::setDatePaid()
     * @uses PaymentRequest::setPaidAmount()
     * @uses PaymentRequest::setTypeId()
     * @uses PaymentRequest::setSoftware()
     * @uses PaymentRequest::setPaymentInternalId()
     * @param string $merchantId
     * @param string $customerId
     * @param string $subCustomerId
     * @param string $divisionId
     * @param string $invoiceNumber
     * @param string $invoiceInternalId
     * @param string $invoiceDate
     * @param string $invoiceDueDate
     * @param string $poNum
     * @param string $soNum
     * @param string $invoiceAmount
     * @param string $amountDue
     * @param string $currency
     * @param string $authCode
     * @param string $refNum
     * @param string $last4
     * @param string $paymentMethod
     * @param string $paymentType
     * @param string $datePaid
     * @param string $paidAmount
     * @param string $typeId
     * @param string $software
     * @param string $paymentInternalId
     */
    public function __construct($merchantId = null, $customerId = null, $subCustomerId = null, $divisionId = null, $invoiceNumber = null, $invoiceInternalId = null, $invoiceDate = null, $invoiceDueDate = null, $poNum = null, $soNum = null, $invoiceAmount = null, $amountDue = null, $currency = null, $authCode = null, $refNum = null, $last4 = null, $paymentMethod = null, $paymentType = null, $datePaid = null, $paidAmount = null, $typeId = null, $software = null, $paymentInternalId = null)
    {
        $this
            ->setMerchantId($merchantId)
            ->setCustomerId($customerId)
            ->setSubCustomerId($subCustomerId)
            ->setDivisionId($divisionId)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceInternalId($invoiceInternalId)
            ->setInvoiceDate($invoiceDate)
            ->setInvoiceDueDate($invoiceDueDate)
            ->setPoNum($poNum)
            ->setSoNum($soNum)
            ->setInvoiceAmount($invoiceAmount)
            ->setAmountDue($amountDue)
            ->setCurrency($currency)
            ->setAuthCode($authCode)
            ->setRefNum($refNum)
            ->setLast4($last4)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentType($paymentType)
            ->setDatePaid($datePaid)
            ->setPaidAmount($paidAmount)
            ->setTypeId($typeId)
            ->setSoftware($software)
            ->setPaymentInternalId($paymentInternalId);
    }
    /**
     * Get MerchantId value
     * @return string|null
     */
    public function getMerchantId()
    {
        return $this->MerchantId;
    }
    /**
     * Set MerchantId value
     * @param string $merchantId
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setMerchantId($merchantId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantId) && !is_string($merchantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantId, true), gettype($merchantId)), __LINE__);
        }
        $this->MerchantId = $merchantId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SubCustomerId value
     * @return string|null
     */
    public function getSubCustomerId()
    {
        return $this->SubCustomerId;
    }
    /**
     * Set SubCustomerId value
     * @param string $subCustomerId
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setSubCustomerId($subCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($subCustomerId) && !is_string($subCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCustomerId, true), gettype($subCustomerId)), __LINE__);
        }
        $this->SubCustomerId = $subCustomerId;
        return $this;
    }
    /**
     * Get DivisionId value
     * @return string|null
     */
    public function getDivisionId()
    {
        return $this->DivisionId;
    }
    /**
     * Set DivisionId value
     * @param string $divisionId
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setDivisionId($divisionId = null)
    {
        // validation for constraint: string
        if (!is_null($divisionId) && !is_string($divisionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($divisionId, true), gettype($divisionId)), __LINE__);
        }
        $this->DivisionId = $divisionId;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceInternalId value
     * @return string|null
     */
    public function getInvoiceInternalId()
    {
        return $this->InvoiceInternalId;
    }
    /**
     * Set InvoiceInternalId value
     * @param string $invoiceInternalId
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setInvoiceInternalId($invoiceInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceInternalId) && !is_string($invoiceInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceInternalId, true), gettype($invoiceInternalId)), __LINE__);
        }
        $this->InvoiceInternalId = $invoiceInternalId;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get InvoiceDueDate value
     * @return string|null
     */
    public function getInvoiceDueDate()
    {
        return $this->InvoiceDueDate;
    }
    /**
     * Set InvoiceDueDate value
     * @param string $invoiceDueDate
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setInvoiceDueDate($invoiceDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDueDate) && !is_string($invoiceDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDueDate, true), gettype($invoiceDueDate)), __LINE__);
        }
        $this->InvoiceDueDate = $invoiceDueDate;
        return $this;
    }
    /**
     * Get PoNum value
     * @return string|null
     */
    public function getPoNum()
    {
        return $this->PoNum;
    }
    /**
     * Set PoNum value
     * @param string $poNum
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setPoNum($poNum = null)
    {
        // validation for constraint: string
        if (!is_null($poNum) && !is_string($poNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poNum, true), gettype($poNum)), __LINE__);
        }
        $this->PoNum = $poNum;
        return $this;
    }
    /**
     * Get SoNum value
     * @return string|null
     */
    public function getSoNum()
    {
        return $this->SoNum;
    }
    /**
     * Set SoNum value
     * @param string $soNum
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setSoNum($soNum = null)
    {
        // validation for constraint: string
        if (!is_null($soNum) && !is_string($soNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soNum, true), gettype($soNum)), __LINE__);
        }
        $this->SoNum = $soNum;
        return $this;
    }
    /**
     * Get InvoiceAmount value
     * @return string|null
     */
    public function getInvoiceAmount()
    {
        return $this->InvoiceAmount;
    }
    /**
     * Set InvoiceAmount value
     * @param string $invoiceAmount
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setInvoiceAmount($invoiceAmount = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceAmount) && !is_string($invoiceAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceAmount, true), gettype($invoiceAmount)), __LINE__);
        }
        $this->InvoiceAmount = $invoiceAmount;
        return $this;
    }
    /**
     * Get AmountDue value
     * @return string|null
     */
    public function getAmountDue()
    {
        return $this->AmountDue;
    }
    /**
     * Set AmountDue value
     * @param string $amountDue
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setAmountDue($amountDue = null)
    {
        // validation for constraint: string
        if (!is_null($amountDue) && !is_string($amountDue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountDue, true), gettype($amountDue)), __LINE__);
        }
        $this->AmountDue = $amountDue;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get RefNum value
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->RefNum;
    }
    /**
     * Set RefNum value
     * @param string $refNum
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setRefNum($refNum = null)
    {
        // validation for constraint: string
        if (!is_null($refNum) && !is_string($refNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNum, true), gettype($refNum)), __LINE__);
        }
        $this->RefNum = $refNum;
        return $this;
    }
    /**
     * Get Last4 value
     * @return string|null
     */
    public function getLast4()
    {
        return $this->Last4;
    }
    /**
     * Set Last4 value
     * @param string $last4
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setLast4($last4 = null)
    {
        // validation for constraint: string
        if (!is_null($last4) && !is_string($last4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last4, true), gettype($last4)), __LINE__);
        }
        $this->Last4 = $last4;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param string $paymentMethod
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get DatePaid value
     * @return string|null
     */
    public function getDatePaid()
    {
        return $this->DatePaid;
    }
    /**
     * Set DatePaid value
     * @param string $datePaid
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setDatePaid($datePaid = null)
    {
        // validation for constraint: string
        if (!is_null($datePaid) && !is_string($datePaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datePaid, true), gettype($datePaid)), __LINE__);
        }
        $this->DatePaid = $datePaid;
        return $this;
    }
    /**
     * Get PaidAmount value
     * @return string|null
     */
    public function getPaidAmount()
    {
        return $this->PaidAmount;
    }
    /**
     * Set PaidAmount value
     * @param string $paidAmount
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setPaidAmount($paidAmount = null)
    {
        // validation for constraint: string
        if (!is_null($paidAmount) && !is_string($paidAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paidAmount, true), gettype($paidAmount)), __LINE__);
        }
        $this->PaidAmount = $paidAmount;
        return $this;
    }
    /**
     * Get TypeId value
     * @return string|null
     */
    public function getTypeId()
    {
        return $this->TypeId;
    }
    /**
     * Set TypeId value
     * @param string $typeId
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        $this->TypeId = $typeId;
        return $this;
    }
    /**
     * Get Software value
     * @return string|null
     */
    public function getSoftware()
    {
        return $this->Software;
    }
    /**
     * Set Software value
     * @param string $software
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setSoftware($software = null)
    {
        // validation for constraint: string
        if (!is_null($software) && !is_string($software)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($software, true), gettype($software)), __LINE__);
        }
        $this->Software = $software;
        return $this;
    }
    /**
     * Get PaymentInternalId value
     * @return string|null
     */
    public function getPaymentInternalId()
    {
        return $this->PaymentInternalId;
    }
    /**
     * Set PaymentInternalId value
     * @param string $paymentInternalId
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public function setPaymentInternalId($paymentInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInternalId) && !is_string($paymentInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInternalId, true), gettype($paymentInternalId)), __LINE__);
        }
        $this->PaymentInternalId = $paymentInternalId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\PaymentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
