<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarkApplicationTransactionAsApplied StructType
 * @subpackage Structs
 */
class MarkApplicationTransactionAsApplied extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The applicationTransactionInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $applicationTransactionInternalId;
    /**
     * Constructor method for MarkApplicationTransactionAsApplied
     * @uses MarkApplicationTransactionAsApplied::setSecurityToken()
     * @uses MarkApplicationTransactionAsApplied::setApplicationTransactionInternalId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $applicationTransactionInternalId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $applicationTransactionInternalId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setApplicationTransactionInternalId($applicationTransactionInternalId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\MarkApplicationTransactionAsApplied
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get applicationTransactionInternalId value
     * @return string|null
     */
    public function getApplicationTransactionInternalId()
    {
        return $this->applicationTransactionInternalId;
    }
    /**
     * Set applicationTransactionInternalId value
     * @param string $applicationTransactionInternalId
     * @return \eBizCharge\StructType\MarkApplicationTransactionAsApplied
     */
    public function setApplicationTransactionInternalId($applicationTransactionInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationTransactionInternalId) && !is_string($applicationTransactionInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationTransactionInternalId, true), gettype($applicationTransactionInternalId)), __LINE__);
        }
        $this->applicationTransactionInternalId = $applicationTransactionInternalId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\MarkApplicationTransactionAsApplied
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
