<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerPaymentMethodProfile StructType
 * @subpackage Structs
 */
class GetCustomerPaymentMethodProfile extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The customerToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerToken;
    /**
     * The paymentMethodId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paymentMethodId;
    /**
     * Constructor method for GetCustomerPaymentMethodProfile
     * @uses GetCustomerPaymentMethodProfile::setSecurityToken()
     * @uses GetCustomerPaymentMethodProfile::setCustomerToken()
     * @uses GetCustomerPaymentMethodProfile::setPaymentMethodId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $customerToken
     * @param string $paymentMethodId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $customerToken = null, $paymentMethodId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setCustomerToken($customerToken)
            ->setPaymentMethodId($paymentMethodId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\GetCustomerPaymentMethodProfile
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get customerToken value
     * @return string|null
     */
    public function getCustomerToken()
    {
        return $this->customerToken;
    }
    /**
     * Set customerToken value
     * @param string $customerToken
     * @return \eBizCharge\StructType\GetCustomerPaymentMethodProfile
     */
    public function setCustomerToken($customerToken = null)
    {
        // validation for constraint: string
        if (!is_null($customerToken) && !is_string($customerToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerToken, true), gettype($customerToken)), __LINE__);
        }
        $this->customerToken = $customerToken;
        return $this;
    }
    /**
     * Get paymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->paymentMethodId;
    }
    /**
     * Set paymentMethodId value
     * @param string $paymentMethodId
     * @return \eBizCharge\StructType\GetCustomerPaymentMethodProfile
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        $this->paymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\GetCustomerPaymentMethodProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
