<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddApplicationData StructType
 * @subpackage Structs
 */
class AddApplicationData extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The applicationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $applicationId;
    /**
     * The lookupKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lookupKey;
    /**
     * The base64String
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $base64String;
    /**
     * Constructor method for AddApplicationData
     * @uses AddApplicationData::setSecurityToken()
     * @uses AddApplicationData::setApplicationId()
     * @uses AddApplicationData::setLookupKey()
     * @uses AddApplicationData::setBase64String()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $applicationId
     * @param string $lookupKey
     * @param string $base64String
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $applicationId = null, $lookupKey = null, $base64String = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setApplicationId($applicationId)
            ->setLookupKey($lookupKey)
            ->setBase64String($base64String);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\AddApplicationData
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get applicationId value
     * @return string|null
     */
    public function getApplicationId()
    {
        return $this->applicationId;
    }
    /**
     * Set applicationId value
     * @param string $applicationId
     * @return \eBizCharge\StructType\AddApplicationData
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        $this->applicationId = $applicationId;
        return $this;
    }
    /**
     * Get lookupKey value
     * @return string|null
     */
    public function getLookupKey()
    {
        return $this->lookupKey;
    }
    /**
     * Set lookupKey value
     * @param string $lookupKey
     * @return \eBizCharge\StructType\AddApplicationData
     */
    public function setLookupKey($lookupKey = null)
    {
        // validation for constraint: string
        if (!is_null($lookupKey) && !is_string($lookupKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lookupKey, true), gettype($lookupKey)), __LINE__);
        }
        $this->lookupKey = $lookupKey;
        return $this;
    }
    /**
     * Get base64String value
     * @return string|null
     */
    public function getBase64String()
    {
        return $this->base64String;
    }
    /**
     * Set base64String value
     * @param string $base64String
     * @return \eBizCharge\StructType\AddApplicationData
     */
    public function setBase64String($base64String = null)
    {
        // validation for constraint: string
        if (!is_null($base64String) && !is_string($base64String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($base64String, true), gettype($base64String)), __LINE__);
        }
        $this->base64String = $base64String;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\AddApplicationData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
