<?php

namespace eBizCharge\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSalesOrder ArrayType
 * @subpackage Arrays
 */
class ArrayOfSalesOrder extends AbstractStructArrayBase
{
    /**
     * The SalesOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \eBizCharge\StructType\SalesOrder[]
     */
    public $SalesOrder;
    /**
     * Constructor method for ArrayOfSalesOrder
     * @uses ArrayOfSalesOrder::setSalesOrder()
     * @param \eBizCharge\StructType\SalesOrder[] $salesOrder
     */
    public function __construct(array $salesOrder = array())
    {
        $this
            ->setSalesOrder($salesOrder);
    }
    /**
     * Get SalesOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eBizCharge\StructType\SalesOrder[]|null
     */
    public function getSalesOrder()
    {
        return isset($this->SalesOrder) ? $this->SalesOrder : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesOrderForArrayConstraintsFromSetSalesOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSalesOrderSalesOrderItem) {
            // validation for constraint: itemType
            if (!$arrayOfSalesOrderSalesOrderItem instanceof \eBizCharge\StructType\SalesOrder) {
                $invalidValues[] = is_object($arrayOfSalesOrderSalesOrderItem) ? get_class($arrayOfSalesOrderSalesOrderItem) : sprintf('%s(%s)', gettype($arrayOfSalesOrderSalesOrderItem), var_export($arrayOfSalesOrderSalesOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesOrder property can only contain items of type \eBizCharge\StructType\SalesOrder, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\SalesOrder[] $salesOrder
     * @return \eBizCharge\ArrayType\ArrayOfSalesOrder
     */
    public function setSalesOrder(array $salesOrder = array())
    {
        // validation for constraint: array
        if ('' !== ($salesOrderArrayErrorMessage = self::validateSalesOrderForArrayConstraintsFromSetSalesOrder($salesOrder))) {
            throw new \InvalidArgumentException($salesOrderArrayErrorMessage, __LINE__);
        }
        if (is_null($salesOrder) || (is_array($salesOrder) && empty($salesOrder))) {
            unset($this->SalesOrder);
        } else {
            $this->SalesOrder = $salesOrder;
        }
        return $this;
    }
    /**
     * Add item to SalesOrder value
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\SalesOrder $item
     * @return \eBizCharge\ArrayType\ArrayOfSalesOrder
     */
    public function addToSalesOrder(\eBizCharge\StructType\SalesOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \eBizCharge\StructType\SalesOrder) {
            throw new \InvalidArgumentException(sprintf('The SalesOrder property can only contain items of type \eBizCharge\StructType\SalesOrder, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesOrder[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \eBizCharge\StructType\SalesOrder|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \eBizCharge\StructType\SalesOrder|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \eBizCharge\StructType\SalesOrder|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \eBizCharge\StructType\SalesOrder|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \eBizCharge\StructType\SalesOrder|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SalesOrder
     */
    public function getAttributeName()
    {
        return 'SalesOrder';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\ArrayType\ArrayOfSalesOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
