<?php

namespace eBizCharge\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemDetails ArrayType
 * @subpackage Arrays
 */
class ArrayOfItemDetails extends AbstractStructArrayBase
{
    /**
     * The ItemDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \eBizCharge\StructType\ItemDetails[]
     */
    public $ItemDetails;
    /**
     * Constructor method for ArrayOfItemDetails
     * @uses ArrayOfItemDetails::setItemDetails()
     * @param \eBizCharge\StructType\ItemDetails[] $itemDetails
     */
    public function __construct(array $itemDetails = array())
    {
        $this
            ->setItemDetails($itemDetails);
    }
    /**
     * Get ItemDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eBizCharge\StructType\ItemDetails[]|null
     */
    public function getItemDetails()
    {
        return isset($this->ItemDetails) ? $this->ItemDetails : null;
    }
    /**
     * This method is responsible for validating the values passed to the setItemDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemDetailsForArrayConstraintsFromSetItemDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfItemDetailsItemDetailsItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemDetailsItemDetailsItem instanceof \eBizCharge\StructType\ItemDetails) {
                $invalidValues[] = is_object($arrayOfItemDetailsItemDetailsItem) ? get_class($arrayOfItemDetailsItemDetailsItem) : sprintf('%s(%s)', gettype($arrayOfItemDetailsItemDetailsItem), var_export($arrayOfItemDetailsItemDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemDetails property can only contain items of type \eBizCharge\StructType\ItemDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\ItemDetails[] $itemDetails
     * @return \eBizCharge\ArrayType\ArrayOfItemDetails
     */
    public function setItemDetails(array $itemDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($itemDetailsArrayErrorMessage = self::validateItemDetailsForArrayConstraintsFromSetItemDetails($itemDetails))) {
            throw new \InvalidArgumentException($itemDetailsArrayErrorMessage, __LINE__);
        }
        if (is_null($itemDetails) || (is_array($itemDetails) && empty($itemDetails))) {
            unset($this->ItemDetails);
        } else {
            $this->ItemDetails = $itemDetails;
        }
        return $this;
    }
    /**
     * Add item to ItemDetails value
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\ItemDetails $item
     * @return \eBizCharge\ArrayType\ArrayOfItemDetails
     */
    public function addToItemDetails(\eBizCharge\StructType\ItemDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \eBizCharge\StructType\ItemDetails) {
            throw new \InvalidArgumentException(sprintf('The ItemDetails property can only contain items of type \eBizCharge\StructType\ItemDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemDetails[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \eBizCharge\StructType\ItemDetails|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \eBizCharge\StructType\ItemDetails|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \eBizCharge\StructType\ItemDetails|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \eBizCharge\StructType\ItemDetails|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \eBizCharge\StructType\ItemDetails|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemDetails
     */
    public function getAttributeName()
    {
        return 'ItemDetails';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\ArrayType\ArrayOfItemDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
