<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MerchantData StructType
 * @subpackage Structs
 */
class MerchantData extends AbstractStructBase
{
    /**
     * The MerchantInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantInternalId;
    /**
     * The MerchantId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantId;
    /**
     * The MerchantName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantName;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ContactFirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactFirstName;
    /**
     * The ContactLastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactLastName;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street;
    /**
     * The Street2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street2;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The Mobile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mobile;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The WebSite
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebSite;
    /**
     * The MerchantSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\MerchantSettings
     */
    public $MerchantSettings;
    /**
     * Constructor method for MerchantData
     * @uses MerchantData::setMerchantInternalId()
     * @uses MerchantData::setMerchantId()
     * @uses MerchantData::setMerchantName()
     * @uses MerchantData::setDescription()
     * @uses MerchantData::setContactFirstName()
     * @uses MerchantData::setContactLastName()
     * @uses MerchantData::setStreet()
     * @uses MerchantData::setStreet2()
     * @uses MerchantData::setCity()
     * @uses MerchantData::setState()
     * @uses MerchantData::setZip()
     * @uses MerchantData::setPhone()
     * @uses MerchantData::setFax()
     * @uses MerchantData::setMobile()
     * @uses MerchantData::setEmail()
     * @uses MerchantData::setWebSite()
     * @uses MerchantData::setMerchantSettings()
     * @param string $merchantInternalId
     * @param string $merchantId
     * @param string $merchantName
     * @param string $description
     * @param string $contactFirstName
     * @param string $contactLastName
     * @param string $street
     * @param string $street2
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $phone
     * @param string $fax
     * @param string $mobile
     * @param string $email
     * @param string $webSite
     * @param \eBizCharge\StructType\MerchantSettings $merchantSettings
     */
    public function __construct($merchantInternalId = null, $merchantId = null, $merchantName = null, $description = null, $contactFirstName = null, $contactLastName = null, $street = null, $street2 = null, $city = null, $state = null, $zip = null, $phone = null, $fax = null, $mobile = null, $email = null, $webSite = null, \eBizCharge\StructType\MerchantSettings $merchantSettings = null)
    {
        $this
            ->setMerchantInternalId($merchantInternalId)
            ->setMerchantId($merchantId)
            ->setMerchantName($merchantName)
            ->setDescription($description)
            ->setContactFirstName($contactFirstName)
            ->setContactLastName($contactLastName)
            ->setStreet($street)
            ->setStreet2($street2)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setPhone($phone)
            ->setFax($fax)
            ->setMobile($mobile)
            ->setEmail($email)
            ->setWebSite($webSite)
            ->setMerchantSettings($merchantSettings);
    }
    /**
     * Get MerchantInternalId value
     * @return string|null
     */
    public function getMerchantInternalId()
    {
        return $this->MerchantInternalId;
    }
    /**
     * Set MerchantInternalId value
     * @param string $merchantInternalId
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setMerchantInternalId($merchantInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantInternalId) && !is_string($merchantInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantInternalId, true), gettype($merchantInternalId)), __LINE__);
        }
        $this->MerchantInternalId = $merchantInternalId;
        return $this;
    }
    /**
     * Get MerchantId value
     * @return string|null
     */
    public function getMerchantId()
    {
        return $this->MerchantId;
    }
    /**
     * Set MerchantId value
     * @param string $merchantId
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setMerchantId($merchantId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantId) && !is_string($merchantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantId, true), gettype($merchantId)), __LINE__);
        }
        $this->MerchantId = $merchantId;
        return $this;
    }
    /**
     * Get MerchantName value
     * @return string|null
     */
    public function getMerchantName()
    {
        return $this->MerchantName;
    }
    /**
     * Set MerchantName value
     * @param string $merchantName
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setMerchantName($merchantName = null)
    {
        // validation for constraint: string
        if (!is_null($merchantName) && !is_string($merchantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantName, true), gettype($merchantName)), __LINE__);
        }
        $this->MerchantName = $merchantName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ContactFirstName value
     * @return string|null
     */
    public function getContactFirstName()
    {
        return $this->ContactFirstName;
    }
    /**
     * Set ContactFirstName value
     * @param string $contactFirstName
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setContactFirstName($contactFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($contactFirstName) && !is_string($contactFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactFirstName, true), gettype($contactFirstName)), __LINE__);
        }
        $this->ContactFirstName = $contactFirstName;
        return $this;
    }
    /**
     * Get ContactLastName value
     * @return string|null
     */
    public function getContactLastName()
    {
        return $this->ContactLastName;
    }
    /**
     * Set ContactLastName value
     * @param string $contactLastName
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setContactLastName($contactLastName = null)
    {
        // validation for constraint: string
        if (!is_null($contactLastName) && !is_string($contactLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactLastName, true), gettype($contactLastName)), __LINE__);
        }
        $this->ContactLastName = $contactLastName;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get Street2 value
     * @return string|null
     */
    public function getStreet2()
    {
        return $this->Street2;
    }
    /**
     * Set Street2 value
     * @param string $street2
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setStreet2($street2 = null)
    {
        // validation for constraint: string
        if (!is_null($street2) && !is_string($street2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street2, true), gettype($street2)), __LINE__);
        }
        $this->Street2 = $street2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get WebSite value
     * @return string|null
     */
    public function getWebSite()
    {
        return $this->WebSite;
    }
    /**
     * Set WebSite value
     * @param string $webSite
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setWebSite($webSite = null)
    {
        // validation for constraint: string
        if (!is_null($webSite) && !is_string($webSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webSite, true), gettype($webSite)), __LINE__);
        }
        $this->WebSite = $webSite;
        return $this;
    }
    /**
     * Get MerchantSettings value
     * @return \eBizCharge\StructType\MerchantSettings|null
     */
    public function getMerchantSettings()
    {
        return $this->MerchantSettings;
    }
    /**
     * Set MerchantSettings value
     * @param \eBizCharge\StructType\MerchantSettings $merchantSettings
     * @return \eBizCharge\StructType\MerchantData
     */
    public function setMerchantSettings(\eBizCharge\StructType\MerchantSettings $merchantSettings = null)
    {
        $this->MerchantSettings = $merchantSettings;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\MerchantData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
