<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Atachment StructType
 * @subpackage Structs
 */
class Atachment extends AbstractStructBase
{
    /**
     * The PermissionAccessLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PermissionAccessLevel;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The FileNameWithExtension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileNameWithExtension;
    /**
     * The FileContents_Binary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileContents_Binary;
    /**
     * The FileContents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileContents;
    /**
     * Constructor method for Atachment
     * @uses Atachment::setPermissionAccessLevel()
     * @uses Atachment::setTitle()
     * @uses Atachment::setDescription()
     * @uses Atachment::setFileNameWithExtension()
     * @uses Atachment::setFileContents_Binary()
     * @uses Atachment::setFileContents()
     * @param int $permissionAccessLevel
     * @param string $title
     * @param string $description
     * @param string $fileNameWithExtension
     * @param string $fileContents_Binary
     * @param string $fileContents
     */
    public function __construct($permissionAccessLevel = null, $title = null, $description = null, $fileNameWithExtension = null, $fileContents_Binary = null, $fileContents = null)
    {
        $this
            ->setPermissionAccessLevel($permissionAccessLevel)
            ->setTitle($title)
            ->setDescription($description)
            ->setFileNameWithExtension($fileNameWithExtension)
            ->setFileContents_Binary($fileContents_Binary)
            ->setFileContents($fileContents);
    }
    /**
     * Get PermissionAccessLevel value
     * @return int
     */
    public function getPermissionAccessLevel()
    {
        return $this->PermissionAccessLevel;
    }
    /**
     * Set PermissionAccessLevel value
     * @param int $permissionAccessLevel
     * @return \eBizCharge\StructType\Atachment
     */
    public function setPermissionAccessLevel($permissionAccessLevel = null)
    {
        // validation for constraint: int
        if (!is_null($permissionAccessLevel) && !(is_int($permissionAccessLevel) || ctype_digit($permissionAccessLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($permissionAccessLevel, true), gettype($permissionAccessLevel)), __LINE__);
        }
        $this->PermissionAccessLevel = $permissionAccessLevel;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \eBizCharge\StructType\Atachment
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \eBizCharge\StructType\Atachment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get FileNameWithExtension value
     * @return string|null
     */
    public function getFileNameWithExtension()
    {
        return $this->FileNameWithExtension;
    }
    /**
     * Set FileNameWithExtension value
     * @param string $fileNameWithExtension
     * @return \eBizCharge\StructType\Atachment
     */
    public function setFileNameWithExtension($fileNameWithExtension = null)
    {
        // validation for constraint: string
        if (!is_null($fileNameWithExtension) && !is_string($fileNameWithExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileNameWithExtension, true), gettype($fileNameWithExtension)), __LINE__);
        }
        $this->FileNameWithExtension = $fileNameWithExtension;
        return $this;
    }
    /**
     * Get FileContents_Binary value
     * @return string|null
     */
    public function getFileContents_Binary()
    {
        return $this->FileContents_Binary;
    }
    /**
     * Set FileContents_Binary value
     * @param string $fileContents_Binary
     * @return \eBizCharge\StructType\Atachment
     */
    public function setFileContents_Binary($fileContents_Binary = null)
    {
        // validation for constraint: string
        if (!is_null($fileContents_Binary) && !is_string($fileContents_Binary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileContents_Binary, true), gettype($fileContents_Binary)), __LINE__);
        }
        $this->FileContents_Binary = $fileContents_Binary;
        return $this;
    }
    /**
     * Get FileContents value
     * @return string|null
     */
    public function getFileContents()
    {
        return $this->FileContents;
    }
    /**
     * Set FileContents value
     * @param string $fileContents
     * @return \eBizCharge\StructType\Atachment
     */
    public function setFileContents($fileContents = null)
    {
        // validation for constraint: string
        if (!is_null($fileContents) && !is_string($fileContents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileContents, true), gettype($fileContents)), __LINE__);
        }
        $this->FileContents = $fileContents;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\Atachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
