<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSalesOrder StructType
 * @subpackage Structs
 */
class GetSalesOrder extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerId;
    /**
     * The subCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subCustomerId;
    /**
     * The salesOrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $salesOrderNumber;
    /**
     * The salesOrderInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $salesOrderInternalId;
    /**
     * Constructor method for GetSalesOrder
     * @uses GetSalesOrder::setSecurityToken()
     * @uses GetSalesOrder::setCustomerId()
     * @uses GetSalesOrder::setSubCustomerId()
     * @uses GetSalesOrder::setSalesOrderNumber()
     * @uses GetSalesOrder::setSalesOrderInternalId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $customerId
     * @param string $subCustomerId
     * @param string $salesOrderNumber
     * @param string $salesOrderInternalId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $customerId = null, $subCustomerId = null, $salesOrderNumber = null, $salesOrderInternalId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setCustomerId($customerId)
            ->setSubCustomerId($subCustomerId)
            ->setSalesOrderNumber($salesOrderNumber)
            ->setSalesOrderInternalId($salesOrderInternalId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\GetSalesOrder
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get customerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\GetSalesOrder
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get subCustomerId value
     * @return string|null
     */
    public function getSubCustomerId()
    {
        return $this->subCustomerId;
    }
    /**
     * Set subCustomerId value
     * @param string $subCustomerId
     * @return \eBizCharge\StructType\GetSalesOrder
     */
    public function setSubCustomerId($subCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($subCustomerId) && !is_string($subCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCustomerId, true), gettype($subCustomerId)), __LINE__);
        }
        $this->subCustomerId = $subCustomerId;
        return $this;
    }
    /**
     * Get salesOrderNumber value
     * @return string|null
     */
    public function getSalesOrderNumber()
    {
        return $this->salesOrderNumber;
    }
    /**
     * Set salesOrderNumber value
     * @param string $salesOrderNumber
     * @return \eBizCharge\StructType\GetSalesOrder
     */
    public function setSalesOrderNumber($salesOrderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($salesOrderNumber) && !is_string($salesOrderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesOrderNumber, true), gettype($salesOrderNumber)), __LINE__);
        }
        $this->salesOrderNumber = $salesOrderNumber;
        return $this;
    }
    /**
     * Get salesOrderInternalId value
     * @return string|null
     */
    public function getSalesOrderInternalId()
    {
        return $this->salesOrderInternalId;
    }
    /**
     * Set salesOrderInternalId value
     * @param string $salesOrderInternalId
     * @return \eBizCharge\StructType\GetSalesOrder
     */
    public function setSalesOrderInternalId($salesOrderInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($salesOrderInternalId) && !is_string($salesOrderInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesOrderInternalId, true), gettype($salesOrderInternalId)), __LINE__);
        }
        $this->salesOrderInternalId = $salesOrderInternalId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\GetSalesOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
