<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddCustomerPaymentMethodProfile StructType
 * @subpackage Structs
 */
class AddCustomerPaymentMethodProfile extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The customerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerInternalId;
    /**
     * The paymentMethodProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\PaymentMethodProfile
     */
    public $paymentMethodProfile;
    /**
     * Constructor method for AddCustomerPaymentMethodProfile
     * @uses AddCustomerPaymentMethodProfile::setSecurityToken()
     * @uses AddCustomerPaymentMethodProfile::setCustomerInternalId()
     * @uses AddCustomerPaymentMethodProfile::setPaymentMethodProfile()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $customerInternalId
     * @param \eBizCharge\StructType\PaymentMethodProfile $paymentMethodProfile
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $customerInternalId = null, \eBizCharge\StructType\PaymentMethodProfile $paymentMethodProfile = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setCustomerInternalId($customerInternalId)
            ->setPaymentMethodProfile($paymentMethodProfile);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\AddCustomerPaymentMethodProfile
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get customerInternalId value
     * @return string|null
     */
    public function getCustomerInternalId()
    {
        return $this->customerInternalId;
    }
    /**
     * Set customerInternalId value
     * @param string $customerInternalId
     * @return \eBizCharge\StructType\AddCustomerPaymentMethodProfile
     */
    public function setCustomerInternalId($customerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($customerInternalId) && !is_string($customerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerInternalId, true), gettype($customerInternalId)), __LINE__);
        }
        $this->customerInternalId = $customerInternalId;
        return $this;
    }
    /**
     * Get paymentMethodProfile value
     * @return \eBizCharge\StructType\PaymentMethodProfile|null
     */
    public function getPaymentMethodProfile()
    {
        return $this->paymentMethodProfile;
    }
    /**
     * Set paymentMethodProfile value
     * @param \eBizCharge\StructType\PaymentMethodProfile $paymentMethodProfile
     * @return \eBizCharge\StructType\AddCustomerPaymentMethodProfile
     */
    public function setPaymentMethodProfile(\eBizCharge\StructType\PaymentMethodProfile $paymentMethodProfile = null)
    {
        $this->paymentMethodProfile = $paymentMethodProfile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\AddCustomerPaymentMethodProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
