<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchCustomers StructType
 * @subpackage Structs
 */
class SearchCustomers extends AbstractStructBase
{
    /**
     * The start
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $start;
    /**
     * The limit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $limit;
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The customerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerInternalId;
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerId;
    /**
     * The sort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sort;
    /**
     * Constructor method for SearchCustomers
     * @uses SearchCustomers::setStart()
     * @uses SearchCustomers::setLimit()
     * @uses SearchCustomers::setSecurityToken()
     * @uses SearchCustomers::setCustomerInternalId()
     * @uses SearchCustomers::setCustomerId()
     * @uses SearchCustomers::setSort()
     * @param int $start
     * @param int $limit
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $customerInternalId
     * @param string $customerId
     * @param string $sort
     */
    public function __construct($start = null, $limit = null, \eBizCharge\StructType\SecurityToken $securityToken = null, $customerInternalId = null, $customerId = null, $sort = null)
    {
        $this
            ->setStart($start)
            ->setLimit($limit)
            ->setSecurityToken($securityToken)
            ->setCustomerInternalId($customerInternalId)
            ->setCustomerId($customerId)
            ->setSort($sort);
    }
    /**
     * Get start value
     * @return int
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param int $start
     * @return \eBizCharge\StructType\SearchCustomers
     */
    public function setStart($start = null)
    {
        // validation for constraint: int
        if (!is_null($start) && !(is_int($start) || ctype_digit($start))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->start = $start;
        return $this;
    }
    /**
     * Get limit value
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \eBizCharge\StructType\SearchCustomers
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\SearchCustomers
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get customerInternalId value
     * @return string|null
     */
    public function getCustomerInternalId()
    {
        return $this->customerInternalId;
    }
    /**
     * Set customerInternalId value
     * @param string $customerInternalId
     * @return \eBizCharge\StructType\SearchCustomers
     */
    public function setCustomerInternalId($customerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($customerInternalId) && !is_string($customerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerInternalId, true), gettype($customerInternalId)), __LINE__);
        }
        $this->customerInternalId = $customerInternalId;
        return $this;
    }
    /**
     * Get customerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\SearchCustomers
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get sort value
     * @return string|null
     */
    public function getSort()
    {
        return $this->sort;
    }
    /**
     * Set sort value
     * @param string $sort
     * @return \eBizCharge\StructType\SearchCustomers
     */
    public function setSort($sort = null)
    {
        // validation for constraint: string
        if (!is_null($sort) && !is_string($sort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->sort = $sort;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\SearchCustomers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
