<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchCustomerList StructType
 * @subpackage Structs
 */
class SearchCustomerList extends AbstractStructBase
{
    /**
     * The start
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $start;
    /**
     * The limit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $limit;
    /**
     * The includeCustomerToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includeCustomerToken;
    /**
     * The includePaymentMethodProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includePaymentMethodProfiles;
    /**
     * The countOnly
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $countOnly;
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The filters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfSearchFilter
     */
    public $filters;
    /**
     * The sort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sort;
    /**
     * Constructor method for SearchCustomerList
     * @uses SearchCustomerList::setStart()
     * @uses SearchCustomerList::setLimit()
     * @uses SearchCustomerList::setIncludeCustomerToken()
     * @uses SearchCustomerList::setIncludePaymentMethodProfiles()
     * @uses SearchCustomerList::setCountOnly()
     * @uses SearchCustomerList::setSecurityToken()
     * @uses SearchCustomerList::setFilters()
     * @uses SearchCustomerList::setSort()
     * @param int $start
     * @param int $limit
     * @param bool $includeCustomerToken
     * @param bool $includePaymentMethodProfiles
     * @param bool $countOnly
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param \eBizCharge\ArrayType\ArrayOfSearchFilter $filters
     * @param string $sort
     */
    public function __construct($start = null, $limit = null, $includeCustomerToken = null, $includePaymentMethodProfiles = null, $countOnly = null, \eBizCharge\StructType\SecurityToken $securityToken = null, \eBizCharge\ArrayType\ArrayOfSearchFilter $filters = null, $sort = null)
    {
        $this
            ->setStart($start)
            ->setLimit($limit)
            ->setIncludeCustomerToken($includeCustomerToken)
            ->setIncludePaymentMethodProfiles($includePaymentMethodProfiles)
            ->setCountOnly($countOnly)
            ->setSecurityToken($securityToken)
            ->setFilters($filters)
            ->setSort($sort);
    }
    /**
     * Get start value
     * @return int
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param int $start
     * @return \eBizCharge\StructType\SearchCustomerList
     */
    public function setStart($start = null)
    {
        // validation for constraint: int
        if (!is_null($start) && !(is_int($start) || ctype_digit($start))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->start = $start;
        return $this;
    }
    /**
     * Get limit value
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \eBizCharge\StructType\SearchCustomerList
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get includeCustomerToken value
     * @return bool
     */
    public function getIncludeCustomerToken()
    {
        return $this->includeCustomerToken;
    }
    /**
     * Set includeCustomerToken value
     * @param bool $includeCustomerToken
     * @return \eBizCharge\StructType\SearchCustomerList
     */
    public function setIncludeCustomerToken($includeCustomerToken = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCustomerToken) && !is_bool($includeCustomerToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCustomerToken, true), gettype($includeCustomerToken)), __LINE__);
        }
        $this->includeCustomerToken = $includeCustomerToken;
        return $this;
    }
    /**
     * Get includePaymentMethodProfiles value
     * @return bool
     */
    public function getIncludePaymentMethodProfiles()
    {
        return $this->includePaymentMethodProfiles;
    }
    /**
     * Set includePaymentMethodProfiles value
     * @param bool $includePaymentMethodProfiles
     * @return \eBizCharge\StructType\SearchCustomerList
     */
    public function setIncludePaymentMethodProfiles($includePaymentMethodProfiles = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePaymentMethodProfiles) && !is_bool($includePaymentMethodProfiles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePaymentMethodProfiles, true), gettype($includePaymentMethodProfiles)), __LINE__);
        }
        $this->includePaymentMethodProfiles = $includePaymentMethodProfiles;
        return $this;
    }
    /**
     * Get countOnly value
     * @return bool
     */
    public function getCountOnly()
    {
        return $this->countOnly;
    }
    /**
     * Set countOnly value
     * @param bool $countOnly
     * @return \eBizCharge\StructType\SearchCustomerList
     */
    public function setCountOnly($countOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($countOnly) && !is_bool($countOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($countOnly, true), gettype($countOnly)), __LINE__);
        }
        $this->countOnly = $countOnly;
        return $this;
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\SearchCustomerList
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get filters value
     * @return \eBizCharge\ArrayType\ArrayOfSearchFilter|null
     */
    public function getFilters()
    {
        return $this->filters;
    }
    /**
     * Set filters value
     * @param \eBizCharge\ArrayType\ArrayOfSearchFilter $filters
     * @return \eBizCharge\StructType\SearchCustomerList
     */
    public function setFilters(\eBizCharge\ArrayType\ArrayOfSearchFilter $filters = null)
    {
        $this->filters = $filters;
        return $this;
    }
    /**
     * Get sort value
     * @return string|null
     */
    public function getSort()
    {
        return $this->sort;
    }
    /**
     * Set sort value
     * @param string $sort
     * @return \eBizCharge\StructType\SearchCustomerList
     */
    public function setSort($sort = null)
    {
        // validation for constraint: string
        if (!is_null($sort) && !is_string($sort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->sort = $sort;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\SearchCustomerList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
