<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerListSearchResult StructType
 * @subpackage Structs
 */
class CustomerListSearchResult extends AbstractStructBase
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Start;
    /**
     * The Limit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Limit;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Count;
    /**
     * The CustomerList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfCustomer
     */
    public $CustomerList;
    /**
     * Constructor method for CustomerListSearchResult
     * @uses CustomerListSearchResult::setStart()
     * @uses CustomerListSearchResult::setLimit()
     * @uses CustomerListSearchResult::setCount()
     * @uses CustomerListSearchResult::setCustomerList()
     * @param int $start
     * @param int $limit
     * @param int $count
     * @param \eBizCharge\ArrayType\ArrayOfCustomer $customerList
     */
    public function __construct($start = null, $limit = null, $count = null, \eBizCharge\ArrayType\ArrayOfCustomer $customerList = null)
    {
        $this
            ->setStart($start)
            ->setLimit($limit)
            ->setCount($count)
            ->setCustomerList($customerList);
    }
    /**
     * Get Start value
     * @return int
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param int $start
     * @return \eBizCharge\StructType\CustomerListSearchResult
     */
    public function setStart($start = null)
    {
        // validation for constraint: int
        if (!is_null($start) && !(is_int($start) || ctype_digit($start))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Limit value
     * @return int
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param int $limit
     * @return \eBizCharge\StructType\CustomerListSearchResult
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get Count value
     * @return int
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \eBizCharge\StructType\CustomerListSearchResult
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get CustomerList value
     * @return \eBizCharge\ArrayType\ArrayOfCustomer|null
     */
    public function getCustomerList()
    {
        return $this->CustomerList;
    }
    /**
     * Set CustomerList value
     * @param \eBizCharge\ArrayType\ArrayOfCustomer $customerList
     * @return \eBizCharge\StructType\CustomerListSearchResult
     */
    public function setCustomerList(\eBizCharge\ArrayType\ArrayOfCustomer $customerList = null)
    {
        $this->CustomerList = $customerList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\CustomerListSearchResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
