<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurityToken StructType
 * @subpackage Structs
 */
class SecurityToken extends AbstractStructBase
{
    /**
     * The SecurityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecurityId;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserId;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for SecurityToken
     * @uses SecurityToken::setSecurityId()
     * @uses SecurityToken::setUserId()
     * @uses SecurityToken::setPassword()
     * @param string $securityId
     * @param string $userId
     * @param string $password
     */
    public function __construct($securityId = null, $userId = null, $password = null)
    {
        $this
            ->setSecurityId($securityId)
            ->setUserId($userId)
            ->setPassword($password);
    }
    /**
     * Get SecurityId value
     * @return string|null
     */
    public function getSecurityId()
    {
        return $this->SecurityId;
    }
    /**
     * Set SecurityId value
     * @param string $securityId
     * @return \eBizCharge\StructType\SecurityToken
     */
    public function setSecurityId($securityId = null)
    {
        // validation for constraint: string
        if (!is_null($securityId) && !is_string($securityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityId, true), gettype($securityId)), __LINE__);
        }
        $this->SecurityId = $securityId;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \eBizCharge\StructType\SecurityToken
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \eBizCharge\StructType\SecurityToken
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\SecurityToken
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
