<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RenderReceipt StructType
 * @subpackage Structs
 */
class RenderReceipt extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The transactionRefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transactionRefNum;
    /**
     * The receiptRefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $receiptRefNum;
    /**
     * The receiptName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $receiptName;
    /**
     * The contentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $contentType;
    /**
     * Constructor method for RenderReceipt
     * @uses RenderReceipt::setSecurityToken()
     * @uses RenderReceipt::setTransactionRefNum()
     * @uses RenderReceipt::setReceiptRefNum()
     * @uses RenderReceipt::setReceiptName()
     * @uses RenderReceipt::setContentType()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $transactionRefNum
     * @param string $receiptRefNum
     * @param string $receiptName
     * @param string $contentType
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $transactionRefNum = null, $receiptRefNum = null, $receiptName = null, $contentType = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setTransactionRefNum($transactionRefNum)
            ->setReceiptRefNum($receiptRefNum)
            ->setReceiptName($receiptName)
            ->setContentType($contentType);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\RenderReceipt
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get transactionRefNum value
     * @return string|null
     */
    public function getTransactionRefNum()
    {
        return $this->transactionRefNum;
    }
    /**
     * Set transactionRefNum value
     * @param string $transactionRefNum
     * @return \eBizCharge\StructType\RenderReceipt
     */
    public function setTransactionRefNum($transactionRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($transactionRefNum) && !is_string($transactionRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionRefNum, true), gettype($transactionRefNum)), __LINE__);
        }
        $this->transactionRefNum = $transactionRefNum;
        return $this;
    }
    /**
     * Get receiptRefNum value
     * @return string|null
     */
    public function getReceiptRefNum()
    {
        return $this->receiptRefNum;
    }
    /**
     * Set receiptRefNum value
     * @param string $receiptRefNum
     * @return \eBizCharge\StructType\RenderReceipt
     */
    public function setReceiptRefNum($receiptRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($receiptRefNum) && !is_string($receiptRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptRefNum, true), gettype($receiptRefNum)), __LINE__);
        }
        $this->receiptRefNum = $receiptRefNum;
        return $this;
    }
    /**
     * Get receiptName value
     * @return string|null
     */
    public function getReceiptName()
    {
        return $this->receiptName;
    }
    /**
     * Set receiptName value
     * @param string $receiptName
     * @return \eBizCharge\StructType\RenderReceipt
     */
    public function setReceiptName($receiptName = null)
    {
        // validation for constraint: string
        if (!is_null($receiptName) && !is_string($receiptName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptName, true), gettype($receiptName)), __LINE__);
        }
        $this->receiptName = $receiptName;
        return $this;
    }
    /**
     * Get contentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->contentType;
    }
    /**
     * Set contentType value
     * @param string $contentType
     * @return \eBizCharge\StructType\RenderReceipt
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentType, true), gettype($contentType)), __LINE__);
        }
        $this->contentType = $contentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\RenderReceipt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
