<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemDetails StructType
 * @subpackage Structs
 */
class ItemDetails extends AbstractStructBase
{
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $UnitPrice;
    /**
     * The UnitCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $UnitCost;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The QtyOnHand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $QtyOnHand;
    /**
     * The Taxable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Taxable;
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxRate;
    /**
     * The ItemInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemInternalId;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The SKU
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SKU;
    /**
     * The UPC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UPC;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The UnitOfMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitOfMeasure;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemType;
    /**
     * The SoftwareId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareId;
    /**
     * The ItemCategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCategoryId;
    /**
     * The ItemNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemNotes;
    /**
     * The DateTimeCreated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTimeCreated;
    /**
     * The DateTimeModified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTimeModified;
    /**
     * The ItemUniqueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemUniqueId;
    /**
     * The ImageUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageUrl;
    /**
     * The TaxCategoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxCategoryID;
    /**
     * The ItemCustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfEbizCustomField
     */
    public $ItemCustomFields;
    /**
     * The ItemLastSyncDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemLastSyncDateTime;
    /**
     * The DivisionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DivisionId;
    /**
     * The LocationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationId;
    /**
     * Constructor method for ItemDetails
     * @uses ItemDetails::setUnitPrice()
     * @uses ItemDetails::setUnitCost()
     * @uses ItemDetails::setActive()
     * @uses ItemDetails::setQtyOnHand()
     * @uses ItemDetails::setTaxable()
     * @uses ItemDetails::setTaxRate()
     * @uses ItemDetails::setItemInternalId()
     * @uses ItemDetails::setItemId()
     * @uses ItemDetails::setName()
     * @uses ItemDetails::setSKU()
     * @uses ItemDetails::setUPC()
     * @uses ItemDetails::setDescription()
     * @uses ItemDetails::setUnitOfMeasure()
     * @uses ItemDetails::setItemType()
     * @uses ItemDetails::setSoftwareId()
     * @uses ItemDetails::setItemCategoryId()
     * @uses ItemDetails::setItemNotes()
     * @uses ItemDetails::setDateTimeCreated()
     * @uses ItemDetails::setDateTimeModified()
     * @uses ItemDetails::setItemUniqueId()
     * @uses ItemDetails::setImageUrl()
     * @uses ItemDetails::setTaxCategoryID()
     * @uses ItemDetails::setItemCustomFields()
     * @uses ItemDetails::setItemLastSyncDateTime()
     * @uses ItemDetails::setDivisionId()
     * @uses ItemDetails::setLocationId()
     * @param float $unitPrice
     * @param float $unitCost
     * @param bool $active
     * @param float $qtyOnHand
     * @param bool $taxable
     * @param float $taxRate
     * @param string $itemInternalId
     * @param string $itemId
     * @param string $name
     * @param string $sKU
     * @param string $uPC
     * @param string $description
     * @param string $unitOfMeasure
     * @param string $itemType
     * @param string $softwareId
     * @param string $itemCategoryId
     * @param string $itemNotes
     * @param string $dateTimeCreated
     * @param string $dateTimeModified
     * @param string $itemUniqueId
     * @param string $imageUrl
     * @param string $taxCategoryID
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $itemCustomFields
     * @param string $itemLastSyncDateTime
     * @param string $divisionId
     * @param string $locationId
     */
    public function __construct($unitPrice = null, $unitCost = null, $active = null, $qtyOnHand = null, $taxable = null, $taxRate = null, $itemInternalId = null, $itemId = null, $name = null, $sKU = null, $uPC = null, $description = null, $unitOfMeasure = null, $itemType = null, $softwareId = null, $itemCategoryId = null, $itemNotes = null, $dateTimeCreated = null, $dateTimeModified = null, $itemUniqueId = null, $imageUrl = null, $taxCategoryID = null, \eBizCharge\ArrayType\ArrayOfEbizCustomField $itemCustomFields = null, $itemLastSyncDateTime = null, $divisionId = null, $locationId = null)
    {
        $this
            ->setUnitPrice($unitPrice)
            ->setUnitCost($unitCost)
            ->setActive($active)
            ->setQtyOnHand($qtyOnHand)
            ->setTaxable($taxable)
            ->setTaxRate($taxRate)
            ->setItemInternalId($itemInternalId)
            ->setItemId($itemId)
            ->setName($name)
            ->setSKU($sKU)
            ->setUPC($uPC)
            ->setDescription($description)
            ->setUnitOfMeasure($unitOfMeasure)
            ->setItemType($itemType)
            ->setSoftwareId($softwareId)
            ->setItemCategoryId($itemCategoryId)
            ->setItemNotes($itemNotes)
            ->setDateTimeCreated($dateTimeCreated)
            ->setDateTimeModified($dateTimeModified)
            ->setItemUniqueId($itemUniqueId)
            ->setImageUrl($imageUrl)
            ->setTaxCategoryID($taxCategoryID)
            ->setItemCustomFields($itemCustomFields)
            ->setItemLastSyncDateTime($itemLastSyncDateTime)
            ->setDivisionId($divisionId)
            ->setLocationId($locationId);
    }
    /**
     * Get UnitPrice value
     * @return float
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get UnitCost value
     * @return float
     */
    public function getUnitCost()
    {
        return $this->UnitCost;
    }
    /**
     * Set UnitCost value
     * @param float $unitCost
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setUnitCost($unitCost = null)
    {
        // validation for constraint: float
        if (!is_null($unitCost) && !(is_float($unitCost) || is_numeric($unitCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitCost, true), gettype($unitCost)), __LINE__);
        }
        $this->UnitCost = $unitCost;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get QtyOnHand value
     * @return float
     */
    public function getQtyOnHand()
    {
        return $this->QtyOnHand;
    }
    /**
     * Set QtyOnHand value
     * @param float $qtyOnHand
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setQtyOnHand($qtyOnHand = null)
    {
        // validation for constraint: float
        if (!is_null($qtyOnHand) && !(is_float($qtyOnHand) || is_numeric($qtyOnHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtyOnHand, true), gettype($qtyOnHand)), __LINE__);
        }
        $this->QtyOnHand = $qtyOnHand;
        return $this;
    }
    /**
     * Get Taxable value
     * @return bool
     */
    public function getTaxable()
    {
        return $this->Taxable;
    }
    /**
     * Set Taxable value
     * @param bool $taxable
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setTaxable($taxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxable) && !is_bool($taxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxable, true), gettype($taxable)), __LINE__);
        }
        $this->Taxable = $taxable;
        return $this;
    }
    /**
     * Get TaxRate value
     * @return float
     */
    public function getTaxRate()
    {
        return $this->TaxRate;
    }
    /**
     * Set TaxRate value
     * @param float $taxRate
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate) && !(is_float($taxRate) || is_numeric($taxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->TaxRate = $taxRate;
        return $this;
    }
    /**
     * Get ItemInternalId value
     * @return string|null
     */
    public function getItemInternalId()
    {
        return $this->ItemInternalId;
    }
    /**
     * Set ItemInternalId value
     * @param string $itemInternalId
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setItemInternalId($itemInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($itemInternalId) && !is_string($itemInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemInternalId, true), gettype($itemInternalId)), __LINE__);
        }
        $this->ItemInternalId = $itemInternalId;
        return $this;
    }
    /**
     * Get ItemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param string $itemId
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get SKU value
     * @return string|null
     */
    public function getSKU()
    {
        return $this->SKU;
    }
    /**
     * Set SKU value
     * @param string $sKU
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setSKU($sKU = null)
    {
        // validation for constraint: string
        if (!is_null($sKU) && !is_string($sKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sKU, true), gettype($sKU)), __LINE__);
        }
        $this->SKU = $sKU;
        return $this;
    }
    /**
     * Get UPC value
     * @return string|null
     */
    public function getUPC()
    {
        return $this->UPC;
    }
    /**
     * Set UPC value
     * @param string $uPC
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setUPC($uPC = null)
    {
        // validation for constraint: string
        if (!is_null($uPC) && !is_string($uPC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uPC, true), gettype($uPC)), __LINE__);
        }
        $this->UPC = $uPC;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get UnitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->UnitOfMeasure;
    }
    /**
     * Set UnitOfMeasure value
     * @param string $unitOfMeasure
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasure) && !is_string($unitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasure, true), gettype($unitOfMeasure)), __LINE__);
        }
        $this->UnitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Get ItemType value
     * @return string|null
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @param string $itemType
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: string
        if (!is_null($itemType) && !is_string($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        $this->ItemType = $itemType;
        return $this;
    }
    /**
     * Get SoftwareId value
     * @return string|null
     */
    public function getSoftwareId()
    {
        return $this->SoftwareId;
    }
    /**
     * Set SoftwareId value
     * @param string $softwareId
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setSoftwareId($softwareId = null)
    {
        // validation for constraint: string
        if (!is_null($softwareId) && !is_string($softwareId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softwareId, true), gettype($softwareId)), __LINE__);
        }
        $this->SoftwareId = $softwareId;
        return $this;
    }
    /**
     * Get ItemCategoryId value
     * @return string|null
     */
    public function getItemCategoryId()
    {
        return $this->ItemCategoryId;
    }
    /**
     * Set ItemCategoryId value
     * @param string $itemCategoryId
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setItemCategoryId($itemCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($itemCategoryId) && !is_string($itemCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCategoryId, true), gettype($itemCategoryId)), __LINE__);
        }
        $this->ItemCategoryId = $itemCategoryId;
        return $this;
    }
    /**
     * Get ItemNotes value
     * @return string|null
     */
    public function getItemNotes()
    {
        return $this->ItemNotes;
    }
    /**
     * Set ItemNotes value
     * @param string $itemNotes
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setItemNotes($itemNotes = null)
    {
        // validation for constraint: string
        if (!is_null($itemNotes) && !is_string($itemNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemNotes, true), gettype($itemNotes)), __LINE__);
        }
        $this->ItemNotes = $itemNotes;
        return $this;
    }
    /**
     * Get DateTimeCreated value
     * @return string|null
     */
    public function getDateTimeCreated()
    {
        return $this->DateTimeCreated;
    }
    /**
     * Set DateTimeCreated value
     * @param string $dateTimeCreated
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setDateTimeCreated($dateTimeCreated = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeCreated) && !is_string($dateTimeCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeCreated, true), gettype($dateTimeCreated)), __LINE__);
        }
        $this->DateTimeCreated = $dateTimeCreated;
        return $this;
    }
    /**
     * Get DateTimeModified value
     * @return string|null
     */
    public function getDateTimeModified()
    {
        return $this->DateTimeModified;
    }
    /**
     * Set DateTimeModified value
     * @param string $dateTimeModified
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setDateTimeModified($dateTimeModified = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeModified) && !is_string($dateTimeModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeModified, true), gettype($dateTimeModified)), __LINE__);
        }
        $this->DateTimeModified = $dateTimeModified;
        return $this;
    }
    /**
     * Get ItemUniqueId value
     * @return string|null
     */
    public function getItemUniqueId()
    {
        return $this->ItemUniqueId;
    }
    /**
     * Set ItemUniqueId value
     * @param string $itemUniqueId
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setItemUniqueId($itemUniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($itemUniqueId) && !is_string($itemUniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemUniqueId, true), gettype($itemUniqueId)), __LINE__);
        }
        $this->ItemUniqueId = $itemUniqueId;
        return $this;
    }
    /**
     * Get ImageUrl value
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->ImageUrl;
    }
    /**
     * Set ImageUrl value
     * @param string $imageUrl
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageUrl, true), gettype($imageUrl)), __LINE__);
        }
        $this->ImageUrl = $imageUrl;
        return $this;
    }
    /**
     * Get TaxCategoryID value
     * @return string|null
     */
    public function getTaxCategoryID()
    {
        return $this->TaxCategoryID;
    }
    /**
     * Set TaxCategoryID value
     * @param string $taxCategoryID
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setTaxCategoryID($taxCategoryID = null)
    {
        // validation for constraint: string
        if (!is_null($taxCategoryID) && !is_string($taxCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCategoryID, true), gettype($taxCategoryID)), __LINE__);
        }
        $this->TaxCategoryID = $taxCategoryID;
        return $this;
    }
    /**
     * Get ItemCustomFields value
     * @return \eBizCharge\ArrayType\ArrayOfEbizCustomField|null
     */
    public function getItemCustomFields()
    {
        return $this->ItemCustomFields;
    }
    /**
     * Set ItemCustomFields value
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $itemCustomFields
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setItemCustomFields(\eBizCharge\ArrayType\ArrayOfEbizCustomField $itemCustomFields = null)
    {
        $this->ItemCustomFields = $itemCustomFields;
        return $this;
    }
    /**
     * Get ItemLastSyncDateTime value
     * @return string|null
     */
    public function getItemLastSyncDateTime()
    {
        return $this->ItemLastSyncDateTime;
    }
    /**
     * Set ItemLastSyncDateTime value
     * @param string $itemLastSyncDateTime
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setItemLastSyncDateTime($itemLastSyncDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($itemLastSyncDateTime) && !is_string($itemLastSyncDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemLastSyncDateTime, true), gettype($itemLastSyncDateTime)), __LINE__);
        }
        $this->ItemLastSyncDateTime = $itemLastSyncDateTime;
        return $this;
    }
    /**
     * Get DivisionId value
     * @return string|null
     */
    public function getDivisionId()
    {
        return $this->DivisionId;
    }
    /**
     * Set DivisionId value
     * @param string $divisionId
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setDivisionId($divisionId = null)
    {
        // validation for constraint: string
        if (!is_null($divisionId) && !is_string($divisionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($divisionId, true), gettype($divisionId)), __LINE__);
        }
        $this->DivisionId = $divisionId;
        return $this;
    }
    /**
     * Get LocationId value
     * @return string|null
     */
    public function getLocationId()
    {
        return $this->LocationId;
    }
    /**
     * Set LocationId value
     * @param string $locationId
     * @return \eBizCharge\StructType\ItemDetails
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: string
        if (!is_null($locationId) && !is_string($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationId, true), gettype($locationId)), __LINE__);
        }
        $this->LocationId = $locationId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\ItemDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
