<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer StructType
 * @subpackage Structs
 */
class Customer extends AbstractStructBase
{
    /**
     * The MerchantId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantId;
    /**
     * The CustomerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerInternalId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The CellPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CellPhone;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The WebSite
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebSite;
    /**
     * The RecurringBillingData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfRecurringBilling
     */
    public $RecurringBillingData;
    /**
     * The BillingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Address
     */
    public $BillingAddress;
    /**
     * The ShippingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Address
     */
    public $ShippingAddress;
    /**
     * The PaymentMethodProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfPaymentMethodProfile
     */
    public $PaymentMethodProfiles;
    /**
     * The CustomerToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerToken;
    /**
     * The CustomerNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNotes;
    /**
     * The SoftwareId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareId;
    /**
     * The CustomerCustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfEbizCustomField
     */
    public $CustomerCustomFields;
    /**
     * The CustomerLastSyncDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerLastSyncDateTime;
    /**
     * The DivisionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DivisionId;
    /**
     * Constructor method for Customer
     * @uses Customer::setMerchantId()
     * @uses Customer::setCustomerInternalId()
     * @uses Customer::setCustomerId()
     * @uses Customer::setFirstName()
     * @uses Customer::setLastName()
     * @uses Customer::setCompanyName()
     * @uses Customer::setPhone()
     * @uses Customer::setCellPhone()
     * @uses Customer::setFax()
     * @uses Customer::setEmail()
     * @uses Customer::setWebSite()
     * @uses Customer::setRecurringBillingData()
     * @uses Customer::setBillingAddress()
     * @uses Customer::setShippingAddress()
     * @uses Customer::setPaymentMethodProfiles()
     * @uses Customer::setCustomerToken()
     * @uses Customer::setCustomerNotes()
     * @uses Customer::setSoftwareId()
     * @uses Customer::setCustomerCustomFields()
     * @uses Customer::setCustomerLastSyncDateTime()
     * @uses Customer::setDivisionId()
     * @param string $merchantId
     * @param string $customerInternalId
     * @param string $customerId
     * @param string $firstName
     * @param string $lastName
     * @param string $companyName
     * @param string $phone
     * @param string $cellPhone
     * @param string $fax
     * @param string $email
     * @param string $webSite
     * @param \eBizCharge\ArrayType\ArrayOfRecurringBilling $recurringBillingData
     * @param \eBizCharge\StructType\Address $billingAddress
     * @param \eBizCharge\StructType\Address $shippingAddress
     * @param \eBizCharge\ArrayType\ArrayOfPaymentMethodProfile $paymentMethodProfiles
     * @param string $customerToken
     * @param string $customerNotes
     * @param string $softwareId
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $customerCustomFields
     * @param string $customerLastSyncDateTime
     * @param string $divisionId
     */
    public function __construct($merchantId = null, $customerInternalId = null, $customerId = null, $firstName = null, $lastName = null, $companyName = null, $phone = null, $cellPhone = null, $fax = null, $email = null, $webSite = null, \eBizCharge\ArrayType\ArrayOfRecurringBilling $recurringBillingData = null, \eBizCharge\StructType\Address $billingAddress = null, \eBizCharge\StructType\Address $shippingAddress = null, \eBizCharge\ArrayType\ArrayOfPaymentMethodProfile $paymentMethodProfiles = null, $customerToken = null, $customerNotes = null, $softwareId = null, \eBizCharge\ArrayType\ArrayOfEbizCustomField $customerCustomFields = null, $customerLastSyncDateTime = null, $divisionId = null)
    {
        $this
            ->setMerchantId($merchantId)
            ->setCustomerInternalId($customerInternalId)
            ->setCustomerId($customerId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCompanyName($companyName)
            ->setPhone($phone)
            ->setCellPhone($cellPhone)
            ->setFax($fax)
            ->setEmail($email)
            ->setWebSite($webSite)
            ->setRecurringBillingData($recurringBillingData)
            ->setBillingAddress($billingAddress)
            ->setShippingAddress($shippingAddress)
            ->setPaymentMethodProfiles($paymentMethodProfiles)
            ->setCustomerToken($customerToken)
            ->setCustomerNotes($customerNotes)
            ->setSoftwareId($softwareId)
            ->setCustomerCustomFields($customerCustomFields)
            ->setCustomerLastSyncDateTime($customerLastSyncDateTime)
            ->setDivisionId($divisionId);
    }
    /**
     * Get MerchantId value
     * @return string|null
     */
    public function getMerchantId()
    {
        return $this->MerchantId;
    }
    /**
     * Set MerchantId value
     * @param string $merchantId
     * @return \eBizCharge\StructType\Customer
     */
    public function setMerchantId($merchantId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantId) && !is_string($merchantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantId, true), gettype($merchantId)), __LINE__);
        }
        $this->MerchantId = $merchantId;
        return $this;
    }
    /**
     * Get CustomerInternalId value
     * @return string|null
     */
    public function getCustomerInternalId()
    {
        return $this->CustomerInternalId;
    }
    /**
     * Set CustomerInternalId value
     * @param string $customerInternalId
     * @return \eBizCharge\StructType\Customer
     */
    public function setCustomerInternalId($customerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($customerInternalId) && !is_string($customerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerInternalId, true), gettype($customerInternalId)), __LINE__);
        }
        $this->CustomerInternalId = $customerInternalId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\Customer
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \eBizCharge\StructType\Customer
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \eBizCharge\StructType\Customer
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \eBizCharge\StructType\Customer
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \eBizCharge\StructType\Customer
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get CellPhone value
     * @return string|null
     */
    public function getCellPhone()
    {
        return $this->CellPhone;
    }
    /**
     * Set CellPhone value
     * @param string $cellPhone
     * @return \eBizCharge\StructType\Customer
     */
    public function setCellPhone($cellPhone = null)
    {
        // validation for constraint: string
        if (!is_null($cellPhone) && !is_string($cellPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cellPhone, true), gettype($cellPhone)), __LINE__);
        }
        $this->CellPhone = $cellPhone;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \eBizCharge\StructType\Customer
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \eBizCharge\StructType\Customer
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get WebSite value
     * @return string|null
     */
    public function getWebSite()
    {
        return $this->WebSite;
    }
    /**
     * Set WebSite value
     * @param string $webSite
     * @return \eBizCharge\StructType\Customer
     */
    public function setWebSite($webSite = null)
    {
        // validation for constraint: string
        if (!is_null($webSite) && !is_string($webSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webSite, true), gettype($webSite)), __LINE__);
        }
        $this->WebSite = $webSite;
        return $this;
    }
    /**
     * Get RecurringBillingData value
     * @return \eBizCharge\ArrayType\ArrayOfRecurringBilling|null
     */
    public function getRecurringBillingData()
    {
        return $this->RecurringBillingData;
    }
    /**
     * Set RecurringBillingData value
     * @param \eBizCharge\ArrayType\ArrayOfRecurringBilling $recurringBillingData
     * @return \eBizCharge\StructType\Customer
     */
    public function setRecurringBillingData(\eBizCharge\ArrayType\ArrayOfRecurringBilling $recurringBillingData = null)
    {
        $this->RecurringBillingData = $recurringBillingData;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \eBizCharge\StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \eBizCharge\StructType\Address $billingAddress
     * @return \eBizCharge\StructType\Customer
     */
    public function setBillingAddress(\eBizCharge\StructType\Address $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \eBizCharge\StructType\Address|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \eBizCharge\StructType\Address $shippingAddress
     * @return \eBizCharge\StructType\Customer
     */
    public function setShippingAddress(\eBizCharge\StructType\Address $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get PaymentMethodProfiles value
     * @return \eBizCharge\ArrayType\ArrayOfPaymentMethodProfile|null
     */
    public function getPaymentMethodProfiles()
    {
        return $this->PaymentMethodProfiles;
    }
    /**
     * Set PaymentMethodProfiles value
     * @param \eBizCharge\ArrayType\ArrayOfPaymentMethodProfile $paymentMethodProfiles
     * @return \eBizCharge\StructType\Customer
     */
    public function setPaymentMethodProfiles(\eBizCharge\ArrayType\ArrayOfPaymentMethodProfile $paymentMethodProfiles = null)
    {
        $this->PaymentMethodProfiles = $paymentMethodProfiles;
        return $this;
    }
    /**
     * Get CustomerToken value
     * @return string|null
     */
    public function getCustomerToken()
    {
        return $this->CustomerToken;
    }
    /**
     * Set CustomerToken value
     * @param string $customerToken
     * @return \eBizCharge\StructType\Customer
     */
    public function setCustomerToken($customerToken = null)
    {
        // validation for constraint: string
        if (!is_null($customerToken) && !is_string($customerToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerToken, true), gettype($customerToken)), __LINE__);
        }
        $this->CustomerToken = $customerToken;
        return $this;
    }
    /**
     * Get CustomerNotes value
     * @return string|null
     */
    public function getCustomerNotes()
    {
        return $this->CustomerNotes;
    }
    /**
     * Set CustomerNotes value
     * @param string $customerNotes
     * @return \eBizCharge\StructType\Customer
     */
    public function setCustomerNotes($customerNotes = null)
    {
        // validation for constraint: string
        if (!is_null($customerNotes) && !is_string($customerNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNotes, true), gettype($customerNotes)), __LINE__);
        }
        $this->CustomerNotes = $customerNotes;
        return $this;
    }
    /**
     * Get SoftwareId value
     * @return string|null
     */
    public function getSoftwareId()
    {
        return $this->SoftwareId;
    }
    /**
     * Set SoftwareId value
     * @param string $softwareId
     * @return \eBizCharge\StructType\Customer
     */
    public function setSoftwareId($softwareId = null)
    {
        // validation for constraint: string
        if (!is_null($softwareId) && !is_string($softwareId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softwareId, true), gettype($softwareId)), __LINE__);
        }
        $this->SoftwareId = $softwareId;
        return $this;
    }
    /**
     * Get CustomerCustomFields value
     * @return \eBizCharge\ArrayType\ArrayOfEbizCustomField|null
     */
    public function getCustomerCustomFields()
    {
        return $this->CustomerCustomFields;
    }
    /**
     * Set CustomerCustomFields value
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $customerCustomFields
     * @return \eBizCharge\StructType\Customer
     */
    public function setCustomerCustomFields(\eBizCharge\ArrayType\ArrayOfEbizCustomField $customerCustomFields = null)
    {
        $this->CustomerCustomFields = $customerCustomFields;
        return $this;
    }
    /**
     * Get CustomerLastSyncDateTime value
     * @return string|null
     */
    public function getCustomerLastSyncDateTime()
    {
        return $this->CustomerLastSyncDateTime;
    }
    /**
     * Set CustomerLastSyncDateTime value
     * @param string $customerLastSyncDateTime
     * @return \eBizCharge\StructType\Customer
     */
    public function setCustomerLastSyncDateTime($customerLastSyncDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($customerLastSyncDateTime) && !is_string($customerLastSyncDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerLastSyncDateTime, true), gettype($customerLastSyncDateTime)), __LINE__);
        }
        $this->CustomerLastSyncDateTime = $customerLastSyncDateTime;
        return $this;
    }
    /**
     * Get DivisionId value
     * @return string|null
     */
    public function getDivisionId()
    {
        return $this->DivisionId;
    }
    /**
     * Set DivisionId value
     * @param string $divisionId
     * @return \eBizCharge\StructType\Customer
     */
    public function setDivisionId($divisionId = null)
    {
        // validation for constraint: string
        if (!is_null($divisionId) && !is_string($divisionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($divisionId, true), gettype($divisionId)), __LINE__);
        }
        $this->DivisionId = $divisionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \eBizCharge\StructType\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
