<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurringFrequency StructType
 * @subpackage Structs
 */
class RecurringFrequency extends AbstractStructBase
{
    /**
     * The FrequencyInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FrequencyInternalId;
    /**
     * The FrequencyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FrequencyId;
    /**
     * The FrequencyDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FrequencyDescription;
    /**
     * The FrequencyNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FrequencyNotes;
    /**
     * Constructor method for RecurringFrequency
     * @uses RecurringFrequency::setFrequencyInternalId()
     * @uses RecurringFrequency::setFrequencyId()
     * @uses RecurringFrequency::setFrequencyDescription()
     * @uses RecurringFrequency::setFrequencyNotes()
     * @param string $frequencyInternalId
     * @param string $frequencyId
     * @param string $frequencyDescription
     * @param string $frequencyNotes
     */
    public function __construct($frequencyInternalId = null, $frequencyId = null, $frequencyDescription = null, $frequencyNotes = null)
    {
        $this
            ->setFrequencyInternalId($frequencyInternalId)
            ->setFrequencyId($frequencyId)
            ->setFrequencyDescription($frequencyDescription)
            ->setFrequencyNotes($frequencyNotes);
    }
    /**
     * Get FrequencyInternalId value
     * @return string|null
     */
    public function getFrequencyInternalId()
    {
        return $this->FrequencyInternalId;
    }
    /**
     * Set FrequencyInternalId value
     * @param string $frequencyInternalId
     * @return \eBizCharge\StructType\RecurringFrequency
     */
    public function setFrequencyInternalId($frequencyInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($frequencyInternalId) && !is_string($frequencyInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequencyInternalId, true), gettype($frequencyInternalId)), __LINE__);
        }
        $this->FrequencyInternalId = $frequencyInternalId;
        return $this;
    }
    /**
     * Get FrequencyId value
     * @return string|null
     */
    public function getFrequencyId()
    {
        return $this->FrequencyId;
    }
    /**
     * Set FrequencyId value
     * @param string $frequencyId
     * @return \eBizCharge\StructType\RecurringFrequency
     */
    public function setFrequencyId($frequencyId = null)
    {
        // validation for constraint: string
        if (!is_null($frequencyId) && !is_string($frequencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequencyId, true), gettype($frequencyId)), __LINE__);
        }
        $this->FrequencyId = $frequencyId;
        return $this;
    }
    /**
     * Get FrequencyDescription value
     * @return string|null
     */
    public function getFrequencyDescription()
    {
        return $this->FrequencyDescription;
    }
    /**
     * Set FrequencyDescription value
     * @param string $frequencyDescription
     * @return \eBizCharge\StructType\RecurringFrequency
     */
    public function setFrequencyDescription($frequencyDescription = null)
    {
        // validation for constraint: string
        if (!is_null($frequencyDescription) && !is_string($frequencyDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequencyDescription, true), gettype($frequencyDescription)), __LINE__);
        }
        $this->FrequencyDescription = $frequencyDescription;
        return $this;
    }
    /**
     * Get FrequencyNotes value
     * @return string|null
     */
    public function getFrequencyNotes()
    {
        return $this->FrequencyNotes;
    }
    /**
     * Set FrequencyNotes value
     * @param string $frequencyNotes
     * @return \eBizCharge\StructType\RecurringFrequency
     */
    public function setFrequencyNotes($frequencyNotes = null)
    {
        // validation for constraint: string
        if (!is_null($frequencyNotes) && !is_string($frequencyNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequencyNotes, true), gettype($frequencyNotes)), __LINE__);
        }
        $this->FrequencyNotes = $frequencyNotes;
        return $this;
    }
}
