<?php

namespace eBizCharge\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMerchantIntegrationSettings ArrayType
 * @subpackage Arrays
 */
class ArrayOfMerchantIntegrationSettings extends AbstractStructArrayBase
{
    /**
     * The MerchantIntegrationSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \eBizCharge\StructType\MerchantIntegrationSettings[]
     */
    public $MerchantIntegrationSettings;
    /**
     * Constructor method for ArrayOfMerchantIntegrationSettings
     * @uses ArrayOfMerchantIntegrationSettings::setMerchantIntegrationSettings()
     * @param \eBizCharge\StructType\MerchantIntegrationSettings[] $merchantIntegrationSettings
     */
    public function __construct(array $merchantIntegrationSettings = array())
    {
        $this
            ->setMerchantIntegrationSettings($merchantIntegrationSettings);
    }
    /**
     * Get MerchantIntegrationSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eBizCharge\StructType\MerchantIntegrationSettings[]|null
     */
    public function getMerchantIntegrationSettings()
    {
        return isset($this->MerchantIntegrationSettings) ? $this->MerchantIntegrationSettings : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMerchantIntegrationSettings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMerchantIntegrationSettings method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMerchantIntegrationSettingsForArrayConstraintsFromSetMerchantIntegrationSettings(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMerchantIntegrationSettingsMerchantIntegrationSettingsItem) {
            // validation for constraint: itemType
            if (!$arrayOfMerchantIntegrationSettingsMerchantIntegrationSettingsItem instanceof \eBizCharge\StructType\MerchantIntegrationSettings) {
                $invalidValues[] = is_object($arrayOfMerchantIntegrationSettingsMerchantIntegrationSettingsItem) ? get_class($arrayOfMerchantIntegrationSettingsMerchantIntegrationSettingsItem) : sprintf('%s(%s)', gettype($arrayOfMerchantIntegrationSettingsMerchantIntegrationSettingsItem), var_export($arrayOfMerchantIntegrationSettingsMerchantIntegrationSettingsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MerchantIntegrationSettings property can only contain items of type \eBizCharge\StructType\MerchantIntegrationSettings, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MerchantIntegrationSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\MerchantIntegrationSettings[] $merchantIntegrationSettings
     * @return \eBizCharge\ArrayType\ArrayOfMerchantIntegrationSettings
     */
    public function setMerchantIntegrationSettings(array $merchantIntegrationSettings = array())
    {
        // validation for constraint: array
        if ('' !== ($merchantIntegrationSettingsArrayErrorMessage = self::validateMerchantIntegrationSettingsForArrayConstraintsFromSetMerchantIntegrationSettings($merchantIntegrationSettings))) {
            throw new \InvalidArgumentException($merchantIntegrationSettingsArrayErrorMessage, __LINE__);
        }
        if (is_null($merchantIntegrationSettings) || (is_array($merchantIntegrationSettings) && empty($merchantIntegrationSettings))) {
            unset($this->MerchantIntegrationSettings);
        } else {
            $this->MerchantIntegrationSettings = $merchantIntegrationSettings;
        }
        return $this;
    }
    /**
     * Add item to MerchantIntegrationSettings value
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\MerchantIntegrationSettings $item
     * @return \eBizCharge\ArrayType\ArrayOfMerchantIntegrationSettings
     */
    public function addToMerchantIntegrationSettings(\eBizCharge\StructType\MerchantIntegrationSettings $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \eBizCharge\StructType\MerchantIntegrationSettings) {
            throw new \InvalidArgumentException(sprintf('The MerchantIntegrationSettings property can only contain items of type \eBizCharge\StructType\MerchantIntegrationSettings, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MerchantIntegrationSettings[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \eBizCharge\StructType\MerchantIntegrationSettings|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \eBizCharge\StructType\MerchantIntegrationSettings|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \eBizCharge\StructType\MerchantIntegrationSettings|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \eBizCharge\StructType\MerchantIntegrationSettings|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \eBizCharge\StructType\MerchantIntegrationSettings|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MerchantIntegrationSettings
     */
    public function getAttributeName()
    {
        return 'MerchantIntegrationSettings';
    }
}
