<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZipCodeData StructType
 * @subpackage Structs
 */
class ZipCodeData extends AbstractStructBase
{
    /**
     * The IsCardFeeAllowed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsCardFeeAllowed;
    /**
     * The MaxAllowedSurchargePercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxAllowedSurchargePercentage;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The StateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StateId;
    /**
     * The StateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StateName;
    /**
     * The CountyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountyName;
    /**
     * The TimeZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeZone;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Longitude;
    /**
     * Constructor method for ZipCodeData
     * @uses ZipCodeData::setIsCardFeeAllowed()
     * @uses ZipCodeData::setMaxAllowedSurchargePercentage()
     * @uses ZipCodeData::setZipCode()
     * @uses ZipCodeData::setCity()
     * @uses ZipCodeData::setStateId()
     * @uses ZipCodeData::setStateName()
     * @uses ZipCodeData::setCountyName()
     * @uses ZipCodeData::setTimeZone()
     * @uses ZipCodeData::setLatitude()
     * @uses ZipCodeData::setLongitude()
     * @param bool $isCardFeeAllowed
     * @param float $maxAllowedSurchargePercentage
     * @param string $zipCode
     * @param string $city
     * @param string $stateId
     * @param string $stateName
     * @param string $countyName
     * @param string $timeZone
     * @param string $latitude
     * @param string $longitude
     */
    public function __construct($isCardFeeAllowed = null, $maxAllowedSurchargePercentage = null, $zipCode = null, $city = null, $stateId = null, $stateName = null, $countyName = null, $timeZone = null, $latitude = null, $longitude = null)
    {
        $this
            ->setIsCardFeeAllowed($isCardFeeAllowed)
            ->setMaxAllowedSurchargePercentage($maxAllowedSurchargePercentage)
            ->setZipCode($zipCode)
            ->setCity($city)
            ->setStateId($stateId)
            ->setStateName($stateName)
            ->setCountyName($countyName)
            ->setTimeZone($timeZone)
            ->setLatitude($latitude)
            ->setLongitude($longitude);
    }
    /**
     * Get IsCardFeeAllowed value
     * @return bool
     */
    public function getIsCardFeeAllowed()
    {
        return $this->IsCardFeeAllowed;
    }
    /**
     * Set IsCardFeeAllowed value
     * @param bool $isCardFeeAllowed
     * @return \eBizCharge\StructType\ZipCodeData
     */
    public function setIsCardFeeAllowed($isCardFeeAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCardFeeAllowed) && !is_bool($isCardFeeAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCardFeeAllowed, true), gettype($isCardFeeAllowed)), __LINE__);
        }
        $this->IsCardFeeAllowed = $isCardFeeAllowed;
        return $this;
    }
    /**
     * Get MaxAllowedSurchargePercentage value
     * @return float
     */
    public function getMaxAllowedSurchargePercentage()
    {
        return $this->MaxAllowedSurchargePercentage;
    }
    /**
     * Set MaxAllowedSurchargePercentage value
     * @param float $maxAllowedSurchargePercentage
     * @return \eBizCharge\StructType\ZipCodeData
     */
    public function setMaxAllowedSurchargePercentage($maxAllowedSurchargePercentage = null)
    {
        // validation for constraint: float
        if (!is_null($maxAllowedSurchargePercentage) && !(is_float($maxAllowedSurchargePercentage) || is_numeric($maxAllowedSurchargePercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxAllowedSurchargePercentage, true), gettype($maxAllowedSurchargePercentage)), __LINE__);
        }
        $this->MaxAllowedSurchargePercentage = $maxAllowedSurchargePercentage;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \eBizCharge\StructType\ZipCodeData
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \eBizCharge\StructType\ZipCodeData
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateId value
     * @return string|null
     */
    public function getStateId()
    {
        return $this->StateId;
    }
    /**
     * Set StateId value
     * @param string $stateId
     * @return \eBizCharge\StructType\ZipCodeData
     */
    public function setStateId($stateId = null)
    {
        // validation for constraint: string
        if (!is_null($stateId) && !is_string($stateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateId, true), gettype($stateId)), __LINE__);
        }
        $this->StateId = $stateId;
        return $this;
    }
    /**
     * Get StateName value
     * @return string|null
     */
    public function getStateName()
    {
        return $this->StateName;
    }
    /**
     * Set StateName value
     * @param string $stateName
     * @return \eBizCharge\StructType\ZipCodeData
     */
    public function setStateName($stateName = null)
    {
        // validation for constraint: string
        if (!is_null($stateName) && !is_string($stateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateName, true), gettype($stateName)), __LINE__);
        }
        $this->StateName = $stateName;
        return $this;
    }
    /**
     * Get CountyName value
     * @return string|null
     */
    public function getCountyName()
    {
        return $this->CountyName;
    }
    /**
     * Set CountyName value
     * @param string $countyName
     * @return \eBizCharge\StructType\ZipCodeData
     */
    public function setCountyName($countyName = null)
    {
        // validation for constraint: string
        if (!is_null($countyName) && !is_string($countyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countyName, true), gettype($countyName)), __LINE__);
        }
        $this->CountyName = $countyName;
        return $this;
    }
    /**
     * Get TimeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @param string $timeZone
     * @return \eBizCharge\StructType\ZipCodeData
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: string
        if (!is_null($timeZone) && !is_string($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZone, true), gettype($timeZone)), __LINE__);
        }
        $this->TimeZone = $timeZone;
        return $this;
    }
    /**
     * Get Latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param string $latitude
     * @return \eBizCharge\StructType\ZipCodeData
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param string $longitude
     * @return \eBizCharge\StructType\ZipCodeData
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
}
