<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for runCustomerTransaction StructType
 * @subpackage Structs
 */
class RunCustomerTransaction extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The custNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $custNum;
    /**
     * The paymentMethodID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paymentMethodID;
    /**
     * The tran
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\CustomerTransactionRequest
     */
    public $tran;
    /**
     * Constructor method for runCustomerTransaction
     * @uses RunCustomerTransaction::setSecurityToken()
     * @uses RunCustomerTransaction::setCustNum()
     * @uses RunCustomerTransaction::setPaymentMethodID()
     * @uses RunCustomerTransaction::setTran()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $custNum
     * @param string $paymentMethodID
     * @param \eBizCharge\StructType\CustomerTransactionRequest $tran
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $custNum = null, $paymentMethodID = null, \eBizCharge\StructType\CustomerTransactionRequest $tran = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setCustNum($custNum)
            ->setPaymentMethodID($paymentMethodID)
            ->setTran($tran);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\RunCustomerTransaction
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get custNum value
     * @return string|null
     */
    public function getCustNum()
    {
        return $this->custNum;
    }
    /**
     * Set custNum value
     * @param string $custNum
     * @return \eBizCharge\StructType\RunCustomerTransaction
     */
    public function setCustNum($custNum = null)
    {
        // validation for constraint: string
        if (!is_null($custNum) && !is_string($custNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custNum, true), gettype($custNum)), __LINE__);
        }
        $this->custNum = $custNum;
        return $this;
    }
    /**
     * Get paymentMethodID value
     * @return string|null
     */
    public function getPaymentMethodID()
    {
        return $this->paymentMethodID;
    }
    /**
     * Set paymentMethodID value
     * @param string $paymentMethodID
     * @return \eBizCharge\StructType\RunCustomerTransaction
     */
    public function setPaymentMethodID($paymentMethodID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodID) && !is_string($paymentMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodID, true), gettype($paymentMethodID)), __LINE__);
        }
        $this->paymentMethodID = $paymentMethodID;
        return $this;
    }
    /**
     * Get tran value
     * @return \eBizCharge\StructType\CustomerTransactionRequest|null
     */
    public function getTran()
    {
        return $this->tran;
    }
    /**
     * Set tran value
     * @param \eBizCharge\StructType\CustomerTransactionRequest $tran
     * @return \eBizCharge\StructType\RunCustomerTransaction
     */
    public function setTran(\eBizCharge\StructType\CustomerTransactionRequest $tran = null)
    {
        $this->tran = $tran;
        return $this;
    }
}
