<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MerchantIntegrationSettings StructType
 * @subpackage Structs
 */
class MerchantIntegrationSettings extends AbstractStructBase
{
    /**
     * The SettingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SettingName;
    /**
     * The SettingValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SettingValue;
    /**
     * The SettingDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SettingDescription;
    /**
     * The SettingCustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfEbizCustomField
     */
    public $SettingCustomFields;
    /**
     * Constructor method for MerchantIntegrationSettings
     * @uses MerchantIntegrationSettings::setSettingName()
     * @uses MerchantIntegrationSettings::setSettingValue()
     * @uses MerchantIntegrationSettings::setSettingDescription()
     * @uses MerchantIntegrationSettings::setSettingCustomFields()
     * @param string $settingName
     * @param string $settingValue
     * @param string $settingDescription
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $settingCustomFields
     */
    public function __construct($settingName = null, $settingValue = null, $settingDescription = null, \eBizCharge\ArrayType\ArrayOfEbizCustomField $settingCustomFields = null)
    {
        $this
            ->setSettingName($settingName)
            ->setSettingValue($settingValue)
            ->setSettingDescription($settingDescription)
            ->setSettingCustomFields($settingCustomFields);
    }
    /**
     * Get SettingName value
     * @return string|null
     */
    public function getSettingName()
    {
        return $this->SettingName;
    }
    /**
     * Set SettingName value
     * @param string $settingName
     * @return \eBizCharge\StructType\MerchantIntegrationSettings
     */
    public function setSettingName($settingName = null)
    {
        // validation for constraint: string
        if (!is_null($settingName) && !is_string($settingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settingName, true), gettype($settingName)), __LINE__);
        }
        $this->SettingName = $settingName;
        return $this;
    }
    /**
     * Get SettingValue value
     * @return string|null
     */
    public function getSettingValue()
    {
        return $this->SettingValue;
    }
    /**
     * Set SettingValue value
     * @param string $settingValue
     * @return \eBizCharge\StructType\MerchantIntegrationSettings
     */
    public function setSettingValue($settingValue = null)
    {
        // validation for constraint: string
        if (!is_null($settingValue) && !is_string($settingValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settingValue, true), gettype($settingValue)), __LINE__);
        }
        $this->SettingValue = $settingValue;
        return $this;
    }
    /**
     * Get SettingDescription value
     * @return string|null
     */
    public function getSettingDescription()
    {
        return $this->SettingDescription;
    }
    /**
     * Set SettingDescription value
     * @param string $settingDescription
     * @return \eBizCharge\StructType\MerchantIntegrationSettings
     */
    public function setSettingDescription($settingDescription = null)
    {
        // validation for constraint: string
        if (!is_null($settingDescription) && !is_string($settingDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settingDescription, true), gettype($settingDescription)), __LINE__);
        }
        $this->SettingDescription = $settingDescription;
        return $this;
    }
    /**
     * Get SettingCustomFields value
     * @return \eBizCharge\ArrayType\ArrayOfEbizCustomField|null
     */
    public function getSettingCustomFields()
    {
        return $this->SettingCustomFields;
    }
    /**
     * Set SettingCustomFields value
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $settingCustomFields
     * @return \eBizCharge\StructType\MerchantIntegrationSettings
     */
    public function setSettingCustomFields(\eBizCharge\ArrayType\ArrayOfEbizCustomField $settingCustomFields = null)
    {
        $this->SettingCustomFields = $settingCustomFields;
        return $this;
    }
}
