<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSalesRep StructType
 * @subpackage Structs
 */
class GetSalesRep extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The salesRepId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $salesRepId;
    /**
     * The salesRepInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $salesRepInternalId;
    /**
     * Constructor method for GetSalesRep
     * @uses GetSalesRep::setSecurityToken()
     * @uses GetSalesRep::setSalesRepId()
     * @uses GetSalesRep::setSalesRepInternalId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $salesRepId
     * @param string $salesRepInternalId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $salesRepId = null, $salesRepInternalId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setSalesRepId($salesRepId)
            ->setSalesRepInternalId($salesRepInternalId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\GetSalesRep
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get salesRepId value
     * @return string|null
     */
    public function getSalesRepId()
    {
        return $this->salesRepId;
    }
    /**
     * Set salesRepId value
     * @param string $salesRepId
     * @return \eBizCharge\StructType\GetSalesRep
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        $this->salesRepId = $salesRepId;
        return $this;
    }
    /**
     * Get salesRepInternalId value
     * @return string|null
     */
    public function getSalesRepInternalId()
    {
        return $this->salesRepInternalId;
    }
    /**
     * Set salesRepInternalId value
     * @param string $salesRepInternalId
     * @return \eBizCharge\StructType\GetSalesRep
     */
    public function setSalesRepInternalId($salesRepInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepInternalId) && !is_string($salesRepInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepInternalId, true), gettype($salesRepInternalId)), __LINE__);
        }
        $this->salesRepInternalId = $salesRepInternalId;
        return $this;
    }
}
