<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationTransactionDetails StructType
 * @subpackage Structs
 */
class ApplicationTransactionDetails extends AbstractStructBase
{
    /**
     * The IsTransactionApplied
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTransactionApplied;
    /**
     * The ApplicationTransactionInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationTransactionInternalId;
    /**
     * The CustomerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerInternalId;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionTypeId;
    /**
     * The SoftwareId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareId;
    /**
     * The LinkedToTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LinkedToTypeId;
    /**
     * The LinkedToInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LinkedToInternalId;
    /**
     * The LinkedToExternalUniqueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LinkedToExternalUniqueId;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionNotes;
    /**
     * The TransactionExternalReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionExternalReferenceNumber;
    /**
     * The TransactionCustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfEbizCustomField
     */
    public $TransactionCustomFields;
    /**
     * The TransactionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionAmount;
    /**
     * The PaymentMethodLast4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethodLast4;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethodType;
    /**
     * Constructor method for ApplicationTransactionDetails
     * @uses ApplicationTransactionDetails::setIsTransactionApplied()
     * @uses ApplicationTransactionDetails::setApplicationTransactionInternalId()
     * @uses ApplicationTransactionDetails::setCustomerInternalId()
     * @uses ApplicationTransactionDetails::setTransactionId()
     * @uses ApplicationTransactionDetails::setTransactionTypeId()
     * @uses ApplicationTransactionDetails::setSoftwareId()
     * @uses ApplicationTransactionDetails::setLinkedToTypeId()
     * @uses ApplicationTransactionDetails::setLinkedToInternalId()
     * @uses ApplicationTransactionDetails::setLinkedToExternalUniqueId()
     * @uses ApplicationTransactionDetails::setTransactionDate()
     * @uses ApplicationTransactionDetails::setTransactionNotes()
     * @uses ApplicationTransactionDetails::setTransactionExternalReferenceNumber()
     * @uses ApplicationTransactionDetails::setTransactionCustomFields()
     * @uses ApplicationTransactionDetails::setTransactionAmount()
     * @uses ApplicationTransactionDetails::setPaymentMethodLast4()
     * @uses ApplicationTransactionDetails::setPaymentMethodType()
     * @param bool $isTransactionApplied
     * @param string $applicationTransactionInternalId
     * @param string $customerInternalId
     * @param string $transactionId
     * @param string $transactionTypeId
     * @param string $softwareId
     * @param string $linkedToTypeId
     * @param string $linkedToInternalId
     * @param string $linkedToExternalUniqueId
     * @param string $transactionDate
     * @param string $transactionNotes
     * @param string $transactionExternalReferenceNumber
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $transactionCustomFields
     * @param string $transactionAmount
     * @param string $paymentMethodLast4
     * @param string $paymentMethodType
     */
    public function __construct($isTransactionApplied = null, $applicationTransactionInternalId = null, $customerInternalId = null, $transactionId = null, $transactionTypeId = null, $softwareId = null, $linkedToTypeId = null, $linkedToInternalId = null, $linkedToExternalUniqueId = null, $transactionDate = null, $transactionNotes = null, $transactionExternalReferenceNumber = null, \eBizCharge\ArrayType\ArrayOfEbizCustomField $transactionCustomFields = null, $transactionAmount = null, $paymentMethodLast4 = null, $paymentMethodType = null)
    {
        $this
            ->setIsTransactionApplied($isTransactionApplied)
            ->setApplicationTransactionInternalId($applicationTransactionInternalId)
            ->setCustomerInternalId($customerInternalId)
            ->setTransactionId($transactionId)
            ->setTransactionTypeId($transactionTypeId)
            ->setSoftwareId($softwareId)
            ->setLinkedToTypeId($linkedToTypeId)
            ->setLinkedToInternalId($linkedToInternalId)
            ->setLinkedToExternalUniqueId($linkedToExternalUniqueId)
            ->setTransactionDate($transactionDate)
            ->setTransactionNotes($transactionNotes)
            ->setTransactionExternalReferenceNumber($transactionExternalReferenceNumber)
            ->setTransactionCustomFields($transactionCustomFields)
            ->setTransactionAmount($transactionAmount)
            ->setPaymentMethodLast4($paymentMethodLast4)
            ->setPaymentMethodType($paymentMethodType);
    }
    /**
     * Get IsTransactionApplied value
     * @return bool
     */
    public function getIsTransactionApplied()
    {
        return $this->IsTransactionApplied;
    }
    /**
     * Set IsTransactionApplied value
     * @param bool $isTransactionApplied
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setIsTransactionApplied($isTransactionApplied = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTransactionApplied) && !is_bool($isTransactionApplied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTransactionApplied, true), gettype($isTransactionApplied)), __LINE__);
        }
        $this->IsTransactionApplied = $isTransactionApplied;
        return $this;
    }
    /**
     * Get ApplicationTransactionInternalId value
     * @return string|null
     */
    public function getApplicationTransactionInternalId()
    {
        return $this->ApplicationTransactionInternalId;
    }
    /**
     * Set ApplicationTransactionInternalId value
     * @param string $applicationTransactionInternalId
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setApplicationTransactionInternalId($applicationTransactionInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationTransactionInternalId) && !is_string($applicationTransactionInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationTransactionInternalId, true), gettype($applicationTransactionInternalId)), __LINE__);
        }
        $this->ApplicationTransactionInternalId = $applicationTransactionInternalId;
        return $this;
    }
    /**
     * Get CustomerInternalId value
     * @return string|null
     */
    public function getCustomerInternalId()
    {
        return $this->CustomerInternalId;
    }
    /**
     * Set CustomerInternalId value
     * @param string $customerInternalId
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setCustomerInternalId($customerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($customerInternalId) && !is_string($customerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerInternalId, true), gettype($customerInternalId)), __LINE__);
        }
        $this->CustomerInternalId = $customerInternalId;
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get TransactionTypeId value
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return $this->TransactionTypeId;
    }
    /**
     * Set TransactionTypeId value
     * @param string $transactionTypeId
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setTransactionTypeId($transactionTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionTypeId) && !is_string($transactionTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionTypeId, true), gettype($transactionTypeId)), __LINE__);
        }
        $this->TransactionTypeId = $transactionTypeId;
        return $this;
    }
    /**
     * Get SoftwareId value
     * @return string|null
     */
    public function getSoftwareId()
    {
        return $this->SoftwareId;
    }
    /**
     * Set SoftwareId value
     * @param string $softwareId
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setSoftwareId($softwareId = null)
    {
        // validation for constraint: string
        if (!is_null($softwareId) && !is_string($softwareId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softwareId, true), gettype($softwareId)), __LINE__);
        }
        $this->SoftwareId = $softwareId;
        return $this;
    }
    /**
     * Get LinkedToTypeId value
     * @return string|null
     */
    public function getLinkedToTypeId()
    {
        return $this->LinkedToTypeId;
    }
    /**
     * Set LinkedToTypeId value
     * @param string $linkedToTypeId
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setLinkedToTypeId($linkedToTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($linkedToTypeId) && !is_string($linkedToTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedToTypeId, true), gettype($linkedToTypeId)), __LINE__);
        }
        $this->LinkedToTypeId = $linkedToTypeId;
        return $this;
    }
    /**
     * Get LinkedToInternalId value
     * @return string|null
     */
    public function getLinkedToInternalId()
    {
        return $this->LinkedToInternalId;
    }
    /**
     * Set LinkedToInternalId value
     * @param string $linkedToInternalId
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setLinkedToInternalId($linkedToInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($linkedToInternalId) && !is_string($linkedToInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedToInternalId, true), gettype($linkedToInternalId)), __LINE__);
        }
        $this->LinkedToInternalId = $linkedToInternalId;
        return $this;
    }
    /**
     * Get LinkedToExternalUniqueId value
     * @return string|null
     */
    public function getLinkedToExternalUniqueId()
    {
        return $this->LinkedToExternalUniqueId;
    }
    /**
     * Set LinkedToExternalUniqueId value
     * @param string $linkedToExternalUniqueId
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setLinkedToExternalUniqueId($linkedToExternalUniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($linkedToExternalUniqueId) && !is_string($linkedToExternalUniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedToExternalUniqueId, true), gettype($linkedToExternalUniqueId)), __LINE__);
        }
        $this->LinkedToExternalUniqueId = $linkedToExternalUniqueId;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string|null
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get TransactionNotes value
     * @return string|null
     */
    public function getTransactionNotes()
    {
        return $this->TransactionNotes;
    }
    /**
     * Set TransactionNotes value
     * @param string $transactionNotes
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setTransactionNotes($transactionNotes = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNotes) && !is_string($transactionNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNotes, true), gettype($transactionNotes)), __LINE__);
        }
        $this->TransactionNotes = $transactionNotes;
        return $this;
    }
    /**
     * Get TransactionExternalReferenceNumber value
     * @return string|null
     */
    public function getTransactionExternalReferenceNumber()
    {
        return $this->TransactionExternalReferenceNumber;
    }
    /**
     * Set TransactionExternalReferenceNumber value
     * @param string $transactionExternalReferenceNumber
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setTransactionExternalReferenceNumber($transactionExternalReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($transactionExternalReferenceNumber) && !is_string($transactionExternalReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionExternalReferenceNumber, true), gettype($transactionExternalReferenceNumber)), __LINE__);
        }
        $this->TransactionExternalReferenceNumber = $transactionExternalReferenceNumber;
        return $this;
    }
    /**
     * Get TransactionCustomFields value
     * @return \eBizCharge\ArrayType\ArrayOfEbizCustomField|null
     */
    public function getTransactionCustomFields()
    {
        return $this->TransactionCustomFields;
    }
    /**
     * Set TransactionCustomFields value
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $transactionCustomFields
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setTransactionCustomFields(\eBizCharge\ArrayType\ArrayOfEbizCustomField $transactionCustomFields = null)
    {
        $this->TransactionCustomFields = $transactionCustomFields;
        return $this;
    }
    /**
     * Get TransactionAmount value
     * @return string|null
     */
    public function getTransactionAmount()
    {
        return $this->TransactionAmount;
    }
    /**
     * Set TransactionAmount value
     * @param string $transactionAmount
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setTransactionAmount($transactionAmount = null)
    {
        // validation for constraint: string
        if (!is_null($transactionAmount) && !is_string($transactionAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionAmount, true), gettype($transactionAmount)), __LINE__);
        }
        $this->TransactionAmount = $transactionAmount;
        return $this;
    }
    /**
     * Get PaymentMethodLast4 value
     * @return string|null
     */
    public function getPaymentMethodLast4()
    {
        return $this->PaymentMethodLast4;
    }
    /**
     * Set PaymentMethodLast4 value
     * @param string $paymentMethodLast4
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setPaymentMethodLast4($paymentMethodLast4 = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodLast4) && !is_string($paymentMethodLast4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodLast4, true), gettype($paymentMethodLast4)), __LINE__);
        }
        $this->PaymentMethodLast4 = $paymentMethodLast4;
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return $this->PaymentMethodType;
    }
    /**
     * Set PaymentMethodType value
     * @param string $paymentMethodType
     * @return \eBizCharge\StructType\ApplicationTransactionDetails
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodType) && !is_string($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodType, true), gettype($paymentMethodType)), __LINE__);
        }
        $this->PaymentMethodType = $paymentMethodType;
        return $this;
    }
}
