<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchEbizWebFormPendingPayments StructType
 * @subpackage Structs
 */
class SearchEbizWebFormPendingPayments extends AbstractStructBase
{
    /**
     * The fromPaymentRequestDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $fromPaymentRequestDateTime;
    /**
     * The toPaymentRequestDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $toPaymentRequestDateTime;
    /**
     * The start
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $start;
    /**
     * The limit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $limit;
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerId;
    /**
     * The filters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfSearchFilter
     */
    public $filters;
    /**
     * The sort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sort;
    /**
     * Constructor method for SearchEbizWebFormPendingPayments
     * @uses SearchEbizWebFormPendingPayments::setFromPaymentRequestDateTime()
     * @uses SearchEbizWebFormPendingPayments::setToPaymentRequestDateTime()
     * @uses SearchEbizWebFormPendingPayments::setStart()
     * @uses SearchEbizWebFormPendingPayments::setLimit()
     * @uses SearchEbizWebFormPendingPayments::setSecurityToken()
     * @uses SearchEbizWebFormPendingPayments::setCustomerId()
     * @uses SearchEbizWebFormPendingPayments::setFilters()
     * @uses SearchEbizWebFormPendingPayments::setSort()
     * @param string $fromPaymentRequestDateTime
     * @param string $toPaymentRequestDateTime
     * @param int $start
     * @param int $limit
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $customerId
     * @param \eBizCharge\ArrayType\ArrayOfSearchFilter $filters
     * @param string $sort
     */
    public function __construct($fromPaymentRequestDateTime = null, $toPaymentRequestDateTime = null, $start = null, $limit = null, \eBizCharge\StructType\SecurityToken $securityToken = null, $customerId = null, \eBizCharge\ArrayType\ArrayOfSearchFilter $filters = null, $sort = null)
    {
        $this
            ->setFromPaymentRequestDateTime($fromPaymentRequestDateTime)
            ->setToPaymentRequestDateTime($toPaymentRequestDateTime)
            ->setStart($start)
            ->setLimit($limit)
            ->setSecurityToken($securityToken)
            ->setCustomerId($customerId)
            ->setFilters($filters)
            ->setSort($sort);
    }
    /**
     * Get fromPaymentRequestDateTime value
     * @return string
     */
    public function getFromPaymentRequestDateTime()
    {
        return $this->fromPaymentRequestDateTime;
    }
    /**
     * Set fromPaymentRequestDateTime value
     * @param string $fromPaymentRequestDateTime
     * @return \eBizCharge\StructType\SearchEbizWebFormPendingPayments
     */
    public function setFromPaymentRequestDateTime($fromPaymentRequestDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($fromPaymentRequestDateTime) && !is_string($fromPaymentRequestDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromPaymentRequestDateTime, true), gettype($fromPaymentRequestDateTime)), __LINE__);
        }
        $this->fromPaymentRequestDateTime = $fromPaymentRequestDateTime;
        return $this;
    }
    /**
     * Get toPaymentRequestDateTime value
     * @return string
     */
    public function getToPaymentRequestDateTime()
    {
        return $this->toPaymentRequestDateTime;
    }
    /**
     * Set toPaymentRequestDateTime value
     * @param string $toPaymentRequestDateTime
     * @return \eBizCharge\StructType\SearchEbizWebFormPendingPayments
     */
    public function setToPaymentRequestDateTime($toPaymentRequestDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($toPaymentRequestDateTime) && !is_string($toPaymentRequestDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toPaymentRequestDateTime, true), gettype($toPaymentRequestDateTime)), __LINE__);
        }
        $this->toPaymentRequestDateTime = $toPaymentRequestDateTime;
        return $this;
    }
    /**
     * Get start value
     * @return int
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param int $start
     * @return \eBizCharge\StructType\SearchEbizWebFormPendingPayments
     */
    public function setStart($start = null)
    {
        // validation for constraint: int
        if (!is_null($start) && !(is_int($start) || ctype_digit($start))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->start = $start;
        return $this;
    }
    /**
     * Get limit value
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \eBizCharge\StructType\SearchEbizWebFormPendingPayments
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\SearchEbizWebFormPendingPayments
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get customerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\SearchEbizWebFormPendingPayments
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get filters value
     * @return \eBizCharge\ArrayType\ArrayOfSearchFilter|null
     */
    public function getFilters()
    {
        return $this->filters;
    }
    /**
     * Set filters value
     * @param \eBizCharge\ArrayType\ArrayOfSearchFilter $filters
     * @return \eBizCharge\StructType\SearchEbizWebFormPendingPayments
     */
    public function setFilters(\eBizCharge\ArrayType\ArrayOfSearchFilter $filters = null)
    {
        $this->filters = $filters;
        return $this;
    }
    /**
     * Get sort value
     * @return string|null
     */
    public function getSort()
    {
        return $this->sort;
    }
    /**
     * Set sort value
     * @param string $sort
     * @return \eBizCharge\StructType\SearchEbizWebFormPendingPayments
     */
    public function setSort($sort = null)
    {
        // validation for constraint: string
        if (!is_null($sort) && !is_string($sort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->sort = $sort;
        return $this;
    }
}
