<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CopyCustomer StructType
 * @subpackage Structs
 */
class CopyCustomer extends AbstractStructBase
{
    /**
     * The customerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerInternalId;
    /**
     * The copyFromSecurityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $copyFromSecurityToken;
    /**
     * The copyToSecurityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $copyToSecurityToken;
    /**
     * Constructor method for CopyCustomer
     * @uses CopyCustomer::setCustomerInternalId()
     * @uses CopyCustomer::setCopyFromSecurityToken()
     * @uses CopyCustomer::setCopyToSecurityToken()
     * @param string $customerInternalId
     * @param \eBizCharge\StructType\SecurityToken $copyFromSecurityToken
     * @param \eBizCharge\StructType\SecurityToken $copyToSecurityToken
     */
    public function __construct($customerInternalId = null, \eBizCharge\StructType\SecurityToken $copyFromSecurityToken = null, \eBizCharge\StructType\SecurityToken $copyToSecurityToken = null)
    {
        $this
            ->setCustomerInternalId($customerInternalId)
            ->setCopyFromSecurityToken($copyFromSecurityToken)
            ->setCopyToSecurityToken($copyToSecurityToken);
    }
    /**
     * Get customerInternalId value
     * @return string|null
     */
    public function getCustomerInternalId()
    {
        return $this->customerInternalId;
    }
    /**
     * Set customerInternalId value
     * @param string $customerInternalId
     * @return \eBizCharge\StructType\CopyCustomer
     */
    public function setCustomerInternalId($customerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($customerInternalId) && !is_string($customerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerInternalId, true), gettype($customerInternalId)), __LINE__);
        }
        $this->customerInternalId = $customerInternalId;
        return $this;
    }
    /**
     * Get copyFromSecurityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getCopyFromSecurityToken()
    {
        return $this->copyFromSecurityToken;
    }
    /**
     * Set copyFromSecurityToken value
     * @param \eBizCharge\StructType\SecurityToken $copyFromSecurityToken
     * @return \eBizCharge\StructType\CopyCustomer
     */
    public function setCopyFromSecurityToken(\eBizCharge\StructType\SecurityToken $copyFromSecurityToken = null)
    {
        $this->copyFromSecurityToken = $copyFromSecurityToken;
        return $this;
    }
    /**
     * Get copyToSecurityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getCopyToSecurityToken()
    {
        return $this->copyToSecurityToken;
    }
    /**
     * Set copyToSecurityToken value
     * @param \eBizCharge\StructType\SecurityToken $copyToSecurityToken
     * @return \eBizCharge\StructType\CopyCustomer
     */
    public function setCopyToSecurityToken(\eBizCharge\StructType\SecurityToken $copyToSecurityToken = null)
    {
        $this->copyToSecurityToken = $copyToSecurityToken;
        return $this;
    }
}
