<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionRequestObject StructType
 * @subpackage Structs
 */
class TransactionRequestObject extends AbstractStructBase
{
    /**
     * The IsRecurring
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRecurring;
    /**
     * The IgnoreDuplicate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IgnoreDuplicate;
    /**
     * The CustReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CustReceipt;
    /**
     * The CustReceiptName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustReceiptName;
    /**
     * The RecurringBilling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\GwRecurringBilling
     */
    public $RecurringBilling;
    /**
     * The LineItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfLineItem
     */
    public $LineItems;
    /**
     * The InventoryLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InventoryLocation;
    /**
     * The IfAuthExpired
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IfAuthExpired;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\TransactionDetail
     */
    public $Details;
    /**
     * The Software
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Software;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfFieldValue
     */
    public $CustomFields;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerID;
    /**
     * The CreditCardData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\CreditCardData
     */
    public $CreditCardData;
    /**
     * The Command
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Command;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The CheckData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\CheckData
     */
    public $CheckData;
    /**
     * The BillingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\GwAddress
     */
    public $BillingAddress;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthCode;
    /**
     * The AccountHolder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountHolder;
    /**
     * The RefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefNum;
    /**
     * The ShippingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\GwAddress
     */
    public $ShippingAddress;
    /**
     * Constructor method for TransactionRequestObject
     * @uses TransactionRequestObject::setIsRecurring()
     * @uses TransactionRequestObject::setIgnoreDuplicate()
     * @uses TransactionRequestObject::setCustReceipt()
     * @uses TransactionRequestObject::setCustReceiptName()
     * @uses TransactionRequestObject::setRecurringBilling()
     * @uses TransactionRequestObject::setLineItems()
     * @uses TransactionRequestObject::setInventoryLocation()
     * @uses TransactionRequestObject::setIfAuthExpired()
     * @uses TransactionRequestObject::setDetails()
     * @uses TransactionRequestObject::setSoftware()
     * @uses TransactionRequestObject::setCustomFields()
     * @uses TransactionRequestObject::setCustomerID()
     * @uses TransactionRequestObject::setCreditCardData()
     * @uses TransactionRequestObject::setCommand()
     * @uses TransactionRequestObject::setClientIP()
     * @uses TransactionRequestObject::setCheckData()
     * @uses TransactionRequestObject::setBillingAddress()
     * @uses TransactionRequestObject::setAuthCode()
     * @uses TransactionRequestObject::setAccountHolder()
     * @uses TransactionRequestObject::setRefNum()
     * @uses TransactionRequestObject::setShippingAddress()
     * @param bool $isRecurring
     * @param bool $ignoreDuplicate
     * @param bool $custReceipt
     * @param string $custReceiptName
     * @param \eBizCharge\StructType\GwRecurringBilling $recurringBilling
     * @param \eBizCharge\ArrayType\ArrayOfLineItem $lineItems
     * @param string $inventoryLocation
     * @param string $ifAuthExpired
     * @param \eBizCharge\StructType\TransactionDetail $details
     * @param string $software
     * @param \eBizCharge\ArrayType\ArrayOfFieldValue $customFields
     * @param string $customerID
     * @param \eBizCharge\StructType\CreditCardData $creditCardData
     * @param string $command
     * @param string $clientIP
     * @param \eBizCharge\StructType\CheckData $checkData
     * @param \eBizCharge\StructType\GwAddress $billingAddress
     * @param string $authCode
     * @param string $accountHolder
     * @param string $refNum
     * @param \eBizCharge\StructType\GwAddress $shippingAddress
     */
    public function __construct($isRecurring = null, $ignoreDuplicate = null, $custReceipt = null, $custReceiptName = null, \eBizCharge\StructType\GwRecurringBilling $recurringBilling = null, \eBizCharge\ArrayType\ArrayOfLineItem $lineItems = null, $inventoryLocation = null, $ifAuthExpired = null, \eBizCharge\StructType\TransactionDetail $details = null, $software = null, \eBizCharge\ArrayType\ArrayOfFieldValue $customFields = null, $customerID = null, \eBizCharge\StructType\CreditCardData $creditCardData = null, $command = null, $clientIP = null, \eBizCharge\StructType\CheckData $checkData = null, \eBizCharge\StructType\GwAddress $billingAddress = null, $authCode = null, $accountHolder = null, $refNum = null, \eBizCharge\StructType\GwAddress $shippingAddress = null)
    {
        $this
            ->setIsRecurring($isRecurring)
            ->setIgnoreDuplicate($ignoreDuplicate)
            ->setCustReceipt($custReceipt)
            ->setCustReceiptName($custReceiptName)
            ->setRecurringBilling($recurringBilling)
            ->setLineItems($lineItems)
            ->setInventoryLocation($inventoryLocation)
            ->setIfAuthExpired($ifAuthExpired)
            ->setDetails($details)
            ->setSoftware($software)
            ->setCustomFields($customFields)
            ->setCustomerID($customerID)
            ->setCreditCardData($creditCardData)
            ->setCommand($command)
            ->setClientIP($clientIP)
            ->setCheckData($checkData)
            ->setBillingAddress($billingAddress)
            ->setAuthCode($authCode)
            ->setAccountHolder($accountHolder)
            ->setRefNum($refNum)
            ->setShippingAddress($shippingAddress);
    }
    /**
     * Get IsRecurring value
     * @return bool
     */
    public function getIsRecurring()
    {
        return $this->IsRecurring;
    }
    /**
     * Set IsRecurring value
     * @param bool $isRecurring
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setIsRecurring($isRecurring = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRecurring) && !is_bool($isRecurring)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRecurring, true), gettype($isRecurring)), __LINE__);
        }
        $this->IsRecurring = $isRecurring;
        return $this;
    }
    /**
     * Get IgnoreDuplicate value
     * @return bool
     */
    public function getIgnoreDuplicate()
    {
        return $this->IgnoreDuplicate;
    }
    /**
     * Set IgnoreDuplicate value
     * @param bool $ignoreDuplicate
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setIgnoreDuplicate($ignoreDuplicate = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreDuplicate) && !is_bool($ignoreDuplicate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreDuplicate, true), gettype($ignoreDuplicate)), __LINE__);
        }
        $this->IgnoreDuplicate = $ignoreDuplicate;
        return $this;
    }
    /**
     * Get CustReceipt value
     * @return bool
     */
    public function getCustReceipt()
    {
        return $this->CustReceipt;
    }
    /**
     * Set CustReceipt value
     * @param bool $custReceipt
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setCustReceipt($custReceipt = null)
    {
        // validation for constraint: boolean
        if (!is_null($custReceipt) && !is_bool($custReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($custReceipt, true), gettype($custReceipt)), __LINE__);
        }
        $this->CustReceipt = $custReceipt;
        return $this;
    }
    /**
     * Get CustReceiptName value
     * @return string|null
     */
    public function getCustReceiptName()
    {
        return $this->CustReceiptName;
    }
    /**
     * Set CustReceiptName value
     * @param string $custReceiptName
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setCustReceiptName($custReceiptName = null)
    {
        // validation for constraint: string
        if (!is_null($custReceiptName) && !is_string($custReceiptName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custReceiptName, true), gettype($custReceiptName)), __LINE__);
        }
        $this->CustReceiptName = $custReceiptName;
        return $this;
    }
    /**
     * Get RecurringBilling value
     * @return \eBizCharge\StructType\GwRecurringBilling|null
     */
    public function getRecurringBilling()
    {
        return $this->RecurringBilling;
    }
    /**
     * Set RecurringBilling value
     * @param \eBizCharge\StructType\GwRecurringBilling $recurringBilling
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setRecurringBilling(\eBizCharge\StructType\GwRecurringBilling $recurringBilling = null)
    {
        $this->RecurringBilling = $recurringBilling;
        return $this;
    }
    /**
     * Get LineItems value
     * @return \eBizCharge\ArrayType\ArrayOfLineItem|null
     */
    public function getLineItems()
    {
        return $this->LineItems;
    }
    /**
     * Set LineItems value
     * @param \eBizCharge\ArrayType\ArrayOfLineItem $lineItems
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setLineItems(\eBizCharge\ArrayType\ArrayOfLineItem $lineItems = null)
    {
        $this->LineItems = $lineItems;
        return $this;
    }
    /**
     * Get InventoryLocation value
     * @return string|null
     */
    public function getInventoryLocation()
    {
        return $this->InventoryLocation;
    }
    /**
     * Set InventoryLocation value
     * @param string $inventoryLocation
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setInventoryLocation($inventoryLocation = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryLocation) && !is_string($inventoryLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryLocation, true), gettype($inventoryLocation)), __LINE__);
        }
        $this->InventoryLocation = $inventoryLocation;
        return $this;
    }
    /**
     * Get IfAuthExpired value
     * @return string|null
     */
    public function getIfAuthExpired()
    {
        return $this->IfAuthExpired;
    }
    /**
     * Set IfAuthExpired value
     * @param string $ifAuthExpired
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setIfAuthExpired($ifAuthExpired = null)
    {
        // validation for constraint: string
        if (!is_null($ifAuthExpired) && !is_string($ifAuthExpired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ifAuthExpired, true), gettype($ifAuthExpired)), __LINE__);
        }
        $this->IfAuthExpired = $ifAuthExpired;
        return $this;
    }
    /**
     * Get Details value
     * @return \eBizCharge\StructType\TransactionDetail|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \eBizCharge\StructType\TransactionDetail $details
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setDetails(\eBizCharge\StructType\TransactionDetail $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Get Software value
     * @return string|null
     */
    public function getSoftware()
    {
        return $this->Software;
    }
    /**
     * Set Software value
     * @param string $software
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setSoftware($software = null)
    {
        // validation for constraint: string
        if (!is_null($software) && !is_string($software)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($software, true), gettype($software)), __LINE__);
        }
        $this->Software = $software;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \eBizCharge\ArrayType\ArrayOfFieldValue|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \eBizCharge\ArrayType\ArrayOfFieldValue $customFields
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setCustomFields(\eBizCharge\ArrayType\ArrayOfFieldValue $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return string|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param string $customerID
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: string
        if (!is_null($customerID) && !is_string($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CreditCardData value
     * @return \eBizCharge\StructType\CreditCardData|null
     */
    public function getCreditCardData()
    {
        return $this->CreditCardData;
    }
    /**
     * Set CreditCardData value
     * @param \eBizCharge\StructType\CreditCardData $creditCardData
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setCreditCardData(\eBizCharge\StructType\CreditCardData $creditCardData = null)
    {
        $this->CreditCardData = $creditCardData;
        return $this;
    }
    /**
     * Get Command value
     * @return string|null
     */
    public function getCommand()
    {
        return $this->Command;
    }
    /**
     * Set Command value
     * @param string $command
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setCommand($command = null)
    {
        // validation for constraint: string
        if (!is_null($command) && !is_string($command)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($command, true), gettype($command)), __LINE__);
        }
        $this->Command = $command;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get CheckData value
     * @return \eBizCharge\StructType\CheckData|null
     */
    public function getCheckData()
    {
        return $this->CheckData;
    }
    /**
     * Set CheckData value
     * @param \eBizCharge\StructType\CheckData $checkData
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setCheckData(\eBizCharge\StructType\CheckData $checkData = null)
    {
        $this->CheckData = $checkData;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \eBizCharge\StructType\GwAddress|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \eBizCharge\StructType\GwAddress $billingAddress
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setBillingAddress(\eBizCharge\StructType\GwAddress $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get AccountHolder value
     * @return string|null
     */
    public function getAccountHolder()
    {
        return $this->AccountHolder;
    }
    /**
     * Set AccountHolder value
     * @param string $accountHolder
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setAccountHolder($accountHolder = null)
    {
        // validation for constraint: string
        if (!is_null($accountHolder) && !is_string($accountHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountHolder, true), gettype($accountHolder)), __LINE__);
        }
        $this->AccountHolder = $accountHolder;
        return $this;
    }
    /**
     * Get RefNum value
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->RefNum;
    }
    /**
     * Set RefNum value
     * @param string $refNum
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setRefNum($refNum = null)
    {
        // validation for constraint: string
        if (!is_null($refNum) && !is_string($refNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNum, true), gettype($refNum)), __LINE__);
        }
        $this->RefNum = $refNum;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \eBizCharge\StructType\GwAddress|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \eBizCharge\StructType\GwAddress $shippingAddress
     * @return \eBizCharge\StructType\TransactionRequestObject
     */
    public function setShippingAddress(\eBizCharge\StructType\GwAddress $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
}
