<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuickInvoicePaymentRequest StructType
 * @subpackage Structs
 */
class QuickInvoicePaymentRequest extends AbstractStructBase
{
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PaidAmount;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The RefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefNum;
    /**
     * The CustNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustNum;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The Software
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Software;
    /**
     * Constructor method for QuickInvoicePaymentRequest
     * @uses QuickInvoicePaymentRequest::setPaidAmount()
     * @uses QuickInvoicePaymentRequest::setCustomerId()
     * @uses QuickInvoicePaymentRequest::setInvoiceNumber()
     * @uses QuickInvoicePaymentRequest::setCurrency()
     * @uses QuickInvoicePaymentRequest::setRefNum()
     * @uses QuickInvoicePaymentRequest::setCustNum()
     * @uses QuickInvoicePaymentRequest::setPaymentMethodId()
     * @uses QuickInvoicePaymentRequest::setPaymentMethodType()
     * @uses QuickInvoicePaymentRequest::setSoftware()
     * @param float $paidAmount
     * @param string $customerId
     * @param string $invoiceNumber
     * @param string $currency
     * @param string $refNum
     * @param string $custNum
     * @param string $paymentMethodId
     * @param string $paymentMethodType
     * @param string $software
     */
    public function __construct($paidAmount = null, $customerId = null, $invoiceNumber = null, $currency = null, $refNum = null, $custNum = null, $paymentMethodId = null, $paymentMethodType = null, $software = null)
    {
        $this
            ->setPaidAmount($paidAmount)
            ->setCustomerId($customerId)
            ->setInvoiceNumber($invoiceNumber)
            ->setCurrency($currency)
            ->setRefNum($refNum)
            ->setCustNum($custNum)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodType($paymentMethodType)
            ->setSoftware($software);
    }
    /**
     * Get PaidAmount value
     * @return float
     */
    public function getPaidAmount()
    {
        return $this->PaidAmount;
    }
    /**
     * Set PaidAmount value
     * @param float $paidAmount
     * @return \eBizCharge\StructType\QuickInvoicePaymentRequest
     */
    public function setPaidAmount($paidAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paidAmount) && !(is_float($paidAmount) || is_numeric($paidAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paidAmount, true), gettype($paidAmount)), __LINE__);
        }
        $this->PaidAmount = $paidAmount;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\QuickInvoicePaymentRequest
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \eBizCharge\StructType\QuickInvoicePaymentRequest
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \eBizCharge\StructType\QuickInvoicePaymentRequest
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get RefNum value
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->RefNum;
    }
    /**
     * Set RefNum value
     * @param string $refNum
     * @return \eBizCharge\StructType\QuickInvoicePaymentRequest
     */
    public function setRefNum($refNum = null)
    {
        // validation for constraint: string
        if (!is_null($refNum) && !is_string($refNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNum, true), gettype($refNum)), __LINE__);
        }
        $this->RefNum = $refNum;
        return $this;
    }
    /**
     * Get CustNum value
     * @return string|null
     */
    public function getCustNum()
    {
        return $this->CustNum;
    }
    /**
     * Set CustNum value
     * @param string $custNum
     * @return \eBizCharge\StructType\QuickInvoicePaymentRequest
     */
    public function setCustNum($custNum = null)
    {
        // validation for constraint: string
        if (!is_null($custNum) && !is_string($custNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custNum, true), gettype($custNum)), __LINE__);
        }
        $this->CustNum = $custNum;
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->PaymentMethodId;
    }
    /**
     * Set PaymentMethodId value
     * @param string $paymentMethodId
     * @return \eBizCharge\StructType\QuickInvoicePaymentRequest
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        $this->PaymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return $this->PaymentMethodType;
    }
    /**
     * Set PaymentMethodType value
     * @param string $paymentMethodType
     * @return \eBizCharge\StructType\QuickInvoicePaymentRequest
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodType) && !is_string($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodType, true), gettype($paymentMethodType)), __LINE__);
        }
        $this->PaymentMethodType = $paymentMethodType;
        return $this;
    }
    /**
     * Get Software value
     * @return string|null
     */
    public function getSoftware()
    {
        return $this->Software;
    }
    /**
     * Set Software value
     * @param string $software
     * @return \eBizCharge\StructType\QuickInvoicePaymentRequest
     */
    public function setSoftware($software = null)
    {
        // validation for constraint: string
        if (!is_null($software) && !is_string($software)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($software, true), gettype($software)), __LINE__);
        }
        $this->Software = $software;
        return $this;
    }
}
