<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateApplicationData StructType
 * @subpackage Structs
 */
class UpdateApplicationData extends AbstractStructBase
{
    /**
     * The applicationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $applicationId;
    /**
     * The lookupKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lookupKey;
    /**
     * The applicationDataInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $applicationDataInternalId;
    /**
     * The applicationData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\ApplicationData
     */
    public $applicationData;
    /**
     * Constructor method for UpdateApplicationData
     * @uses UpdateApplicationData::setApplicationId()
     * @uses UpdateApplicationData::setLookupKey()
     * @uses UpdateApplicationData::setApplicationDataInternalId()
     * @uses UpdateApplicationData::setApplicationData()
     * @param string $applicationId
     * @param string $lookupKey
     * @param string $applicationDataInternalId
     * @param \eBizCharge\StructType\ApplicationData $applicationData
     */
    public function __construct($applicationId = null, $lookupKey = null, $applicationDataInternalId = null, \eBizCharge\StructType\ApplicationData $applicationData = null)
    {
        $this
            ->setApplicationId($applicationId)
            ->setLookupKey($lookupKey)
            ->setApplicationDataInternalId($applicationDataInternalId)
            ->setApplicationData($applicationData);
    }
    /**
     * Get applicationId value
     * @return string|null
     */
    public function getApplicationId()
    {
        return $this->applicationId;
    }
    /**
     * Set applicationId value
     * @param string $applicationId
     * @return \eBizCharge\StructType\UpdateApplicationData
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        $this->applicationId = $applicationId;
        return $this;
    }
    /**
     * Get lookupKey value
     * @return string|null
     */
    public function getLookupKey()
    {
        return $this->lookupKey;
    }
    /**
     * Set lookupKey value
     * @param string $lookupKey
     * @return \eBizCharge\StructType\UpdateApplicationData
     */
    public function setLookupKey($lookupKey = null)
    {
        // validation for constraint: string
        if (!is_null($lookupKey) && !is_string($lookupKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lookupKey, true), gettype($lookupKey)), __LINE__);
        }
        $this->lookupKey = $lookupKey;
        return $this;
    }
    /**
     * Get applicationDataInternalId value
     * @return string|null
     */
    public function getApplicationDataInternalId()
    {
        return $this->applicationDataInternalId;
    }
    /**
     * Set applicationDataInternalId value
     * @param string $applicationDataInternalId
     * @return \eBizCharge\StructType\UpdateApplicationData
     */
    public function setApplicationDataInternalId($applicationDataInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationDataInternalId) && !is_string($applicationDataInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationDataInternalId, true), gettype($applicationDataInternalId)), __LINE__);
        }
        $this->applicationDataInternalId = $applicationDataInternalId;
        return $this;
    }
    /**
     * Get applicationData value
     * @return \eBizCharge\StructType\ApplicationData|null
     */
    public function getApplicationData()
    {
        return $this->applicationData;
    }
    /**
     * Set applicationData value
     * @param \eBizCharge\StructType\ApplicationData $applicationData
     * @return \eBizCharge\StructType\UpdateApplicationData
     */
    public function setApplicationData(\eBizCharge\StructType\ApplicationData $applicationData = null)
    {
        $this->applicationData = $applicationData;
        return $this;
    }
}
