<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionResponse StructType
 * @subpackage Structs
 */
class TransactionResponse extends AbstractStructBase
{
    /**
     * The RemainingBalance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RemainingBalance;
    /**
     * The isDuplicate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isDuplicate;
    /**
     * The ConvertedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ConvertedAmount;
    /**
     * The ConversionRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ConversionRate;
    /**
     * The AuthAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AuthAmount;
    /**
     * The CustNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustNum;
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultCode;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Result;
    /**
     * The RefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefNum;
    /**
     * The ProfilerReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfilerReason;
    /**
     * The ProfilerResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfilerResponse;
    /**
     * The ProfilerScore
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfilerScore;
    /**
     * The Payload
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Payload;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorCode;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Error;
    /**
     * The VpasResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VpasResultCode;
    /**
     * The ConvertedAmountCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConvertedAmountCurrency;
    /**
     * The CardLevelResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardLevelResultCode;
    /**
     * The CardLevelResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardLevelResult;
    /**
     * The CardCodeResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardCodeResultCode;
    /**
     * The CardCodeResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardCodeResult;
    /**
     * The BatchRefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BatchRefNum;
    /**
     * The BatchNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BatchNum;
    /**
     * The AvsResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvsResultCode;
    /**
     * The AvsResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvsResult;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthCode;
    /**
     * The AcsUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AcsUrl;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * Constructor method for TransactionResponse
     * @uses TransactionResponse::setRemainingBalance()
     * @uses TransactionResponse::setIsDuplicate()
     * @uses TransactionResponse::setConvertedAmount()
     * @uses TransactionResponse::setConversionRate()
     * @uses TransactionResponse::setAuthAmount()
     * @uses TransactionResponse::setCustNum()
     * @uses TransactionResponse::setResultCode()
     * @uses TransactionResponse::setResult()
     * @uses TransactionResponse::setRefNum()
     * @uses TransactionResponse::setProfilerReason()
     * @uses TransactionResponse::setProfilerResponse()
     * @uses TransactionResponse::setProfilerScore()
     * @uses TransactionResponse::setPayload()
     * @uses TransactionResponse::setErrorCode()
     * @uses TransactionResponse::setError()
     * @uses TransactionResponse::setVpasResultCode()
     * @uses TransactionResponse::setConvertedAmountCurrency()
     * @uses TransactionResponse::setCardLevelResultCode()
     * @uses TransactionResponse::setCardLevelResult()
     * @uses TransactionResponse::setCardCodeResultCode()
     * @uses TransactionResponse::setCardCodeResult()
     * @uses TransactionResponse::setBatchRefNum()
     * @uses TransactionResponse::setBatchNum()
     * @uses TransactionResponse::setAvsResultCode()
     * @uses TransactionResponse::setAvsResult()
     * @uses TransactionResponse::setAuthCode()
     * @uses TransactionResponse::setAcsUrl()
     * @uses TransactionResponse::setStatus()
     * @uses TransactionResponse::setStatusCode()
     * @param float $remainingBalance
     * @param bool $isDuplicate
     * @param float $convertedAmount
     * @param float $conversionRate
     * @param float $authAmount
     * @param string $custNum
     * @param string $resultCode
     * @param string $result
     * @param string $refNum
     * @param string $profilerReason
     * @param string $profilerResponse
     * @param string $profilerScore
     * @param string $payload
     * @param string $errorCode
     * @param string $error
     * @param string $vpasResultCode
     * @param string $convertedAmountCurrency
     * @param string $cardLevelResultCode
     * @param string $cardLevelResult
     * @param string $cardCodeResultCode
     * @param string $cardCodeResult
     * @param string $batchRefNum
     * @param string $batchNum
     * @param string $avsResultCode
     * @param string $avsResult
     * @param string $authCode
     * @param string $acsUrl
     * @param string $status
     * @param string $statusCode
     */
    public function __construct($remainingBalance = null, $isDuplicate = null, $convertedAmount = null, $conversionRate = null, $authAmount = null, $custNum = null, $resultCode = null, $result = null, $refNum = null, $profilerReason = null, $profilerResponse = null, $profilerScore = null, $payload = null, $errorCode = null, $error = null, $vpasResultCode = null, $convertedAmountCurrency = null, $cardLevelResultCode = null, $cardLevelResult = null, $cardCodeResultCode = null, $cardCodeResult = null, $batchRefNum = null, $batchNum = null, $avsResultCode = null, $avsResult = null, $authCode = null, $acsUrl = null, $status = null, $statusCode = null)
    {
        $this
            ->setRemainingBalance($remainingBalance)
            ->setIsDuplicate($isDuplicate)
            ->setConvertedAmount($convertedAmount)
            ->setConversionRate($conversionRate)
            ->setAuthAmount($authAmount)
            ->setCustNum($custNum)
            ->setResultCode($resultCode)
            ->setResult($result)
            ->setRefNum($refNum)
            ->setProfilerReason($profilerReason)
            ->setProfilerResponse($profilerResponse)
            ->setProfilerScore($profilerScore)
            ->setPayload($payload)
            ->setErrorCode($errorCode)
            ->setError($error)
            ->setVpasResultCode($vpasResultCode)
            ->setConvertedAmountCurrency($convertedAmountCurrency)
            ->setCardLevelResultCode($cardLevelResultCode)
            ->setCardLevelResult($cardLevelResult)
            ->setCardCodeResultCode($cardCodeResultCode)
            ->setCardCodeResult($cardCodeResult)
            ->setBatchRefNum($batchRefNum)
            ->setBatchNum($batchNum)
            ->setAvsResultCode($avsResultCode)
            ->setAvsResult($avsResult)
            ->setAuthCode($authCode)
            ->setAcsUrl($acsUrl)
            ->setStatus($status)
            ->setStatusCode($statusCode);
    }
    /**
     * Get RemainingBalance value
     * @return float
     */
    public function getRemainingBalance()
    {
        return $this->RemainingBalance;
    }
    /**
     * Set RemainingBalance value
     * @param float $remainingBalance
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setRemainingBalance($remainingBalance = null)
    {
        // validation for constraint: float
        if (!is_null($remainingBalance) && !(is_float($remainingBalance) || is_numeric($remainingBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remainingBalance, true), gettype($remainingBalance)), __LINE__);
        }
        $this->RemainingBalance = $remainingBalance;
        return $this;
    }
    /**
     * Get isDuplicate value
     * @return bool
     */
    public function getIsDuplicate()
    {
        return $this->isDuplicate;
    }
    /**
     * Set isDuplicate value
     * @param bool $isDuplicate
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setIsDuplicate($isDuplicate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDuplicate) && !is_bool($isDuplicate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDuplicate, true), gettype($isDuplicate)), __LINE__);
        }
        $this->isDuplicate = $isDuplicate;
        return $this;
    }
    /**
     * Get ConvertedAmount value
     * @return float
     */
    public function getConvertedAmount()
    {
        return $this->ConvertedAmount;
    }
    /**
     * Set ConvertedAmount value
     * @param float $convertedAmount
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setConvertedAmount($convertedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($convertedAmount) && !(is_float($convertedAmount) || is_numeric($convertedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($convertedAmount, true), gettype($convertedAmount)), __LINE__);
        }
        $this->ConvertedAmount = $convertedAmount;
        return $this;
    }
    /**
     * Get ConversionRate value
     * @return float
     */
    public function getConversionRate()
    {
        return $this->ConversionRate;
    }
    /**
     * Set ConversionRate value
     * @param float $conversionRate
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setConversionRate($conversionRate = null)
    {
        // validation for constraint: float
        if (!is_null($conversionRate) && !(is_float($conversionRate) || is_numeric($conversionRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversionRate, true), gettype($conversionRate)), __LINE__);
        }
        $this->ConversionRate = $conversionRate;
        return $this;
    }
    /**
     * Get AuthAmount value
     * @return float
     */
    public function getAuthAmount()
    {
        return $this->AuthAmount;
    }
    /**
     * Set AuthAmount value
     * @param float $authAmount
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setAuthAmount($authAmount = null)
    {
        // validation for constraint: float
        if (!is_null($authAmount) && !(is_float($authAmount) || is_numeric($authAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($authAmount, true), gettype($authAmount)), __LINE__);
        }
        $this->AuthAmount = $authAmount;
        return $this;
    }
    /**
     * Get CustNum value
     * @return string|null
     */
    public function getCustNum()
    {
        return $this->CustNum;
    }
    /**
     * Set CustNum value
     * @param string $custNum
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setCustNum($custNum = null)
    {
        // validation for constraint: string
        if (!is_null($custNum) && !is_string($custNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custNum, true), gettype($custNum)), __LINE__);
        }
        $this->CustNum = $custNum;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get Result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get RefNum value
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->RefNum;
    }
    /**
     * Set RefNum value
     * @param string $refNum
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setRefNum($refNum = null)
    {
        // validation for constraint: string
        if (!is_null($refNum) && !is_string($refNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNum, true), gettype($refNum)), __LINE__);
        }
        $this->RefNum = $refNum;
        return $this;
    }
    /**
     * Get ProfilerReason value
     * @return string|null
     */
    public function getProfilerReason()
    {
        return $this->ProfilerReason;
    }
    /**
     * Set ProfilerReason value
     * @param string $profilerReason
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setProfilerReason($profilerReason = null)
    {
        // validation for constraint: string
        if (!is_null($profilerReason) && !is_string($profilerReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profilerReason, true), gettype($profilerReason)), __LINE__);
        }
        $this->ProfilerReason = $profilerReason;
        return $this;
    }
    /**
     * Get ProfilerResponse value
     * @return string|null
     */
    public function getProfilerResponse()
    {
        return $this->ProfilerResponse;
    }
    /**
     * Set ProfilerResponse value
     * @param string $profilerResponse
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setProfilerResponse($profilerResponse = null)
    {
        // validation for constraint: string
        if (!is_null($profilerResponse) && !is_string($profilerResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profilerResponse, true), gettype($profilerResponse)), __LINE__);
        }
        $this->ProfilerResponse = $profilerResponse;
        return $this;
    }
    /**
     * Get ProfilerScore value
     * @return string|null
     */
    public function getProfilerScore()
    {
        return $this->ProfilerScore;
    }
    /**
     * Set ProfilerScore value
     * @param string $profilerScore
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setProfilerScore($profilerScore = null)
    {
        // validation for constraint: string
        if (!is_null($profilerScore) && !is_string($profilerScore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profilerScore, true), gettype($profilerScore)), __LINE__);
        }
        $this->ProfilerScore = $profilerScore;
        return $this;
    }
    /**
     * Get Payload value
     * @return string|null
     */
    public function getPayload()
    {
        return $this->Payload;
    }
    /**
     * Set Payload value
     * @param string $payload
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setPayload($payload = null)
    {
        // validation for constraint: string
        if (!is_null($payload) && !is_string($payload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payload, true), gettype($payload)), __LINE__);
        }
        $this->Payload = $payload;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Get VpasResultCode value
     * @return string|null
     */
    public function getVpasResultCode()
    {
        return $this->VpasResultCode;
    }
    /**
     * Set VpasResultCode value
     * @param string $vpasResultCode
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setVpasResultCode($vpasResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($vpasResultCode) && !is_string($vpasResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vpasResultCode, true), gettype($vpasResultCode)), __LINE__);
        }
        $this->VpasResultCode = $vpasResultCode;
        return $this;
    }
    /**
     * Get ConvertedAmountCurrency value
     * @return string|null
     */
    public function getConvertedAmountCurrency()
    {
        return $this->ConvertedAmountCurrency;
    }
    /**
     * Set ConvertedAmountCurrency value
     * @param string $convertedAmountCurrency
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setConvertedAmountCurrency($convertedAmountCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($convertedAmountCurrency) && !is_string($convertedAmountCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($convertedAmountCurrency, true), gettype($convertedAmountCurrency)), __LINE__);
        }
        $this->ConvertedAmountCurrency = $convertedAmountCurrency;
        return $this;
    }
    /**
     * Get CardLevelResultCode value
     * @return string|null
     */
    public function getCardLevelResultCode()
    {
        return $this->CardLevelResultCode;
    }
    /**
     * Set CardLevelResultCode value
     * @param string $cardLevelResultCode
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setCardLevelResultCode($cardLevelResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardLevelResultCode) && !is_string($cardLevelResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardLevelResultCode, true), gettype($cardLevelResultCode)), __LINE__);
        }
        $this->CardLevelResultCode = $cardLevelResultCode;
        return $this;
    }
    /**
     * Get CardLevelResult value
     * @return string|null
     */
    public function getCardLevelResult()
    {
        return $this->CardLevelResult;
    }
    /**
     * Set CardLevelResult value
     * @param string $cardLevelResult
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setCardLevelResult($cardLevelResult = null)
    {
        // validation for constraint: string
        if (!is_null($cardLevelResult) && !is_string($cardLevelResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardLevelResult, true), gettype($cardLevelResult)), __LINE__);
        }
        $this->CardLevelResult = $cardLevelResult;
        return $this;
    }
    /**
     * Get CardCodeResultCode value
     * @return string|null
     */
    public function getCardCodeResultCode()
    {
        return $this->CardCodeResultCode;
    }
    /**
     * Set CardCodeResultCode value
     * @param string $cardCodeResultCode
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setCardCodeResultCode($cardCodeResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCodeResultCode) && !is_string($cardCodeResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCodeResultCode, true), gettype($cardCodeResultCode)), __LINE__);
        }
        $this->CardCodeResultCode = $cardCodeResultCode;
        return $this;
    }
    /**
     * Get CardCodeResult value
     * @return string|null
     */
    public function getCardCodeResult()
    {
        return $this->CardCodeResult;
    }
    /**
     * Set CardCodeResult value
     * @param string $cardCodeResult
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setCardCodeResult($cardCodeResult = null)
    {
        // validation for constraint: string
        if (!is_null($cardCodeResult) && !is_string($cardCodeResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCodeResult, true), gettype($cardCodeResult)), __LINE__);
        }
        $this->CardCodeResult = $cardCodeResult;
        return $this;
    }
    /**
     * Get BatchRefNum value
     * @return string|null
     */
    public function getBatchRefNum()
    {
        return $this->BatchRefNum;
    }
    /**
     * Set BatchRefNum value
     * @param string $batchRefNum
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setBatchRefNum($batchRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($batchRefNum) && !is_string($batchRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchRefNum, true), gettype($batchRefNum)), __LINE__);
        }
        $this->BatchRefNum = $batchRefNum;
        return $this;
    }
    /**
     * Get BatchNum value
     * @return string|null
     */
    public function getBatchNum()
    {
        return $this->BatchNum;
    }
    /**
     * Set BatchNum value
     * @param string $batchNum
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setBatchNum($batchNum = null)
    {
        // validation for constraint: string
        if (!is_null($batchNum) && !is_string($batchNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchNum, true), gettype($batchNum)), __LINE__);
        }
        $this->BatchNum = $batchNum;
        return $this;
    }
    /**
     * Get AvsResultCode value
     * @return string|null
     */
    public function getAvsResultCode()
    {
        return $this->AvsResultCode;
    }
    /**
     * Set AvsResultCode value
     * @param string $avsResultCode
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setAvsResultCode($avsResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($avsResultCode) && !is_string($avsResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($avsResultCode, true), gettype($avsResultCode)), __LINE__);
        }
        $this->AvsResultCode = $avsResultCode;
        return $this;
    }
    /**
     * Get AvsResult value
     * @return string|null
     */
    public function getAvsResult()
    {
        return $this->AvsResult;
    }
    /**
     * Set AvsResult value
     * @param string $avsResult
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setAvsResult($avsResult = null)
    {
        // validation for constraint: string
        if (!is_null($avsResult) && !is_string($avsResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($avsResult, true), gettype($avsResult)), __LINE__);
        }
        $this->AvsResult = $avsResult;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get AcsUrl value
     * @return string|null
     */
    public function getAcsUrl()
    {
        return $this->AcsUrl;
    }
    /**
     * Set AcsUrl value
     * @param string $acsUrl
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setAcsUrl($acsUrl = null)
    {
        // validation for constraint: string
        if (!is_null($acsUrl) && !is_string($acsUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acsUrl, true), gettype($acsUrl)), __LINE__);
        }
        $this->AcsUrl = $acsUrl;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \eBizCharge\StructType\TransactionResponse
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
}
