<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarkCustomerAsInactive StructType
 * @subpackage Structs
 */
class MarkCustomerAsInactive extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The customerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerInternalId;
    /**
     * Constructor method for MarkCustomerAsInactive
     * @uses MarkCustomerAsInactive::setSecurityToken()
     * @uses MarkCustomerAsInactive::setCustomerInternalId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $customerInternalId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $customerInternalId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setCustomerInternalId($customerInternalId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\MarkCustomerAsInactive
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get customerInternalId value
     * @return string|null
     */
    public function getCustomerInternalId()
    {
        return $this->customerInternalId;
    }
    /**
     * Set customerInternalId value
     * @param string $customerInternalId
     * @return \eBizCharge\StructType\MarkCustomerAsInactive
     */
    public function setCustomerInternalId($customerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($customerInternalId) && !is_string($customerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerInternalId, true), gettype($customerInternalId)), __LINE__);
        }
        $this->customerInternalId = $customerInternalId;
        return $this;
    }
}
