<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationData StructType
 * @subpackage Structs
 */
class ApplicationData extends AbstractStructBase
{
    /**
     * The ApplicationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationId;
    /**
     * The LookupKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LookupKey;
    /**
     * The Base64ParametersString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Base64ParametersString;
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The ApplicationDataInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationDataInternalId;
    /**
     * Constructor method for ApplicationData
     * @uses ApplicationData::setApplicationId()
     * @uses ApplicationData::setLookupKey()
     * @uses ApplicationData::setBase64ParametersString()
     * @uses ApplicationData::setSecurityToken()
     * @uses ApplicationData::setApplicationDataInternalId()
     * @param string $applicationId
     * @param string $lookupKey
     * @param string $base64ParametersString
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $applicationDataInternalId
     */
    public function __construct($applicationId = null, $lookupKey = null, $base64ParametersString = null, \eBizCharge\StructType\SecurityToken $securityToken = null, $applicationDataInternalId = null)
    {
        $this
            ->setApplicationId($applicationId)
            ->setLookupKey($lookupKey)
            ->setBase64ParametersString($base64ParametersString)
            ->setSecurityToken($securityToken)
            ->setApplicationDataInternalId($applicationDataInternalId);
    }
    /**
     * Get ApplicationId value
     * @return string|null
     */
    public function getApplicationId()
    {
        return $this->ApplicationId;
    }
    /**
     * Set ApplicationId value
     * @param string $applicationId
     * @return \eBizCharge\StructType\ApplicationData
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        $this->ApplicationId = $applicationId;
        return $this;
    }
    /**
     * Get LookupKey value
     * @return string|null
     */
    public function getLookupKey()
    {
        return $this->LookupKey;
    }
    /**
     * Set LookupKey value
     * @param string $lookupKey
     * @return \eBizCharge\StructType\ApplicationData
     */
    public function setLookupKey($lookupKey = null)
    {
        // validation for constraint: string
        if (!is_null($lookupKey) && !is_string($lookupKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lookupKey, true), gettype($lookupKey)), __LINE__);
        }
        $this->LookupKey = $lookupKey;
        return $this;
    }
    /**
     * Get Base64ParametersString value
     * @return string|null
     */
    public function getBase64ParametersString()
    {
        return $this->Base64ParametersString;
    }
    /**
     * Set Base64ParametersString value
     * @param string $base64ParametersString
     * @return \eBizCharge\StructType\ApplicationData
     */
    public function setBase64ParametersString($base64ParametersString = null)
    {
        // validation for constraint: string
        if (!is_null($base64ParametersString) && !is_string($base64ParametersString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($base64ParametersString, true), gettype($base64ParametersString)), __LINE__);
        }
        $this->Base64ParametersString = $base64ParametersString;
        return $this;
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\ApplicationData
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get ApplicationDataInternalId value
     * @return string|null
     */
    public function getApplicationDataInternalId()
    {
        return $this->ApplicationDataInternalId;
    }
    /**
     * Set ApplicationDataInternalId value
     * @param string $applicationDataInternalId
     * @return \eBizCharge\StructType\ApplicationData
     */
    public function setApplicationDataInternalId($applicationDataInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationDataInternalId) && !is_string($applicationDataInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationDataInternalId, true), gettype($applicationDataInternalId)), __LINE__);
        }
        $this->ApplicationDataInternalId = $applicationDataInternalId;
        return $this;
    }
}
