<?php

namespace eBizCharge\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\UpdateCustomer $parameters
     * @return \eBizCharge\StructType\UpdateCustomerResponse|bool
     */
    public function UpdateCustomer(\eBizCharge\StructType\UpdateCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSubCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\UpdateSubCustomer $parameters
     * @return \eBizCharge\StructType\UpdateSubCustomerResponse|bool
     */
    public function UpdateSubCustomer(\eBizCharge\StructType\UpdateSubCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateSubCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\UpdateInvoice $parameters
     * @return \eBizCharge\StructType\UpdateInvoiceResponse|bool
     */
    public function UpdateInvoice(\eBizCharge\StructType\UpdateInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\UpdateItem $parameters
     * @return \eBizCharge\StructType\UpdateItemResponse|bool
     */
    public function UpdateItem(\eBizCharge\StructType\UpdateItem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateUserData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\UpdateUserData $parameters
     * @return \eBizCharge\StructType\UpdateUserDataResponse|bool
     */
    public function UpdateUserData(\eBizCharge\StructType\UpdateUserData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateUserData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateMerchantData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\UpdateMerchantData $parameters
     * @return \eBizCharge\StructType\UpdateMerchantDataResponse|bool
     */
    public function UpdateMerchantData(\eBizCharge\StructType\UpdateMerchantData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateMerchantData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerPaymentMethodProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\UpdateCustomerPaymentMethodProfile $parameters
     * @return \eBizCharge\StructType\UpdateCustomerPaymentMethodProfileResponse|bool
     */
    public function UpdateCustomerPaymentMethodProfile(\eBizCharge\StructType\UpdateCustomerPaymentMethodProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomerPaymentMethodProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateApplicationData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\UpdateApplicationData $parameters
     * @return \eBizCharge\StructType\UpdateApplicationDataResponse|bool
     */
    public function UpdateApplicationData(\eBizCharge\StructType\UpdateApplicationData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateApplicationData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSalesOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\UpdateSalesOrder $parameters
     * @return \eBizCharge\StructType\UpdateSalesOrderResponse|bool
     */
    public function UpdateSalesOrder(\eBizCharge\StructType\UpdateSalesOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateSalesOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSalesRep
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\UpdateSalesRep $parameters
     * @return \eBizCharge\StructType\UpdateSalesRepResponse|bool
     */
    public function UpdateSalesRep(\eBizCharge\StructType\UpdateSalesRep $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateSalesRep($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateTerms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\UpdateTerms $parameters
     * @return \eBizCharge\StructType\UpdateTermsResponse|bool
     */
    public function UpdateTerms(\eBizCharge\StructType\UpdateTerms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateTerms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eBizCharge\StructType\UpdateApplicationDataResponse|\eBizCharge\StructType\UpdateCustomerPaymentMethodProfileResponse|\eBizCharge\StructType\UpdateCustomerResponse|\eBizCharge\StructType\UpdateInvoiceResponse|\eBizCharge\StructType\UpdateItemResponse|\eBizCharge\StructType\UpdateMerchantDataResponse|\eBizCharge\StructType\UpdateSalesOrderResponse|\eBizCharge\StructType\UpdateSalesRepResponse|\eBizCharge\StructType\UpdateSubCustomerResponse|\eBizCharge\StructType\UpdateTermsResponse|\eBizCharge\StructType\UpdateUserDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
