<?php

namespace eBizCharge\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUserData ArrayType
 * @subpackage Arrays
 */
class ArrayOfUserData extends AbstractStructArrayBase
{
    /**
     * The UserData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \eBizCharge\StructType\UserData[]
     */
    public $UserData;
    /**
     * Constructor method for ArrayOfUserData
     * @uses ArrayOfUserData::setUserData()
     * @param \eBizCharge\StructType\UserData[] $userData
     */
    public function __construct(array $userData = array())
    {
        $this
            ->setUserData($userData);
    }
    /**
     * Get UserData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eBizCharge\StructType\UserData[]|null
     */
    public function getUserData()
    {
        return isset($this->UserData) ? $this->UserData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setUserData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserDataForArrayConstraintsFromSetUserData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfUserDataUserDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfUserDataUserDataItem instanceof \eBizCharge\StructType\UserData) {
                $invalidValues[] = is_object($arrayOfUserDataUserDataItem) ? get_class($arrayOfUserDataUserDataItem) : sprintf('%s(%s)', gettype($arrayOfUserDataUserDataItem), var_export($arrayOfUserDataUserDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserData property can only contain items of type \eBizCharge\StructType\UserData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\UserData[] $userData
     * @return \eBizCharge\ArrayType\ArrayOfUserData
     */
    public function setUserData(array $userData = array())
    {
        // validation for constraint: array
        if ('' !== ($userDataArrayErrorMessage = self::validateUserDataForArrayConstraintsFromSetUserData($userData))) {
            throw new \InvalidArgumentException($userDataArrayErrorMessage, __LINE__);
        }
        if (is_null($userData) || (is_array($userData) && empty($userData))) {
            unset($this->UserData);
        } else {
            $this->UserData = $userData;
        }
        return $this;
    }
    /**
     * Add item to UserData value
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\UserData $item
     * @return \eBizCharge\ArrayType\ArrayOfUserData
     */
    public function addToUserData(\eBizCharge\StructType\UserData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \eBizCharge\StructType\UserData) {
            throw new \InvalidArgumentException(sprintf('The UserData property can only contain items of type \eBizCharge\StructType\UserData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \eBizCharge\StructType\UserData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \eBizCharge\StructType\UserData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \eBizCharge\StructType\UserData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \eBizCharge\StructType\UserData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \eBizCharge\StructType\UserData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UserData
     */
    public function getAttributeName()
    {
        return 'UserData';
    }
}
