<?php

namespace eBizCharge\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransactionObject ArrayType
 * @subpackage Arrays
 */
class ArrayOfTransactionObject extends AbstractStructArrayBase
{
    /**
     * The TransactionObject
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \eBizCharge\StructType\TransactionObject[]
     */
    public $TransactionObject;
    /**
     * Constructor method for ArrayOfTransactionObject
     * @uses ArrayOfTransactionObject::setTransactionObject()
     * @param \eBizCharge\StructType\TransactionObject[] $transactionObject
     */
    public function __construct(array $transactionObject = array())
    {
        $this
            ->setTransactionObject($transactionObject);
    }
    /**
     * Get TransactionObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eBizCharge\StructType\TransactionObject[]|null
     */
    public function getTransactionObject()
    {
        return isset($this->TransactionObject) ? $this->TransactionObject : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTransactionObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransactionObject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransactionObjectForArrayConstraintsFromSetTransactionObject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTransactionObjectTransactionObjectItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransactionObjectTransactionObjectItem instanceof \eBizCharge\StructType\TransactionObject) {
                $invalidValues[] = is_object($arrayOfTransactionObjectTransactionObjectItem) ? get_class($arrayOfTransactionObjectTransactionObjectItem) : sprintf('%s(%s)', gettype($arrayOfTransactionObjectTransactionObjectItem), var_export($arrayOfTransactionObjectTransactionObjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransactionObject property can only contain items of type \eBizCharge\StructType\TransactionObject, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransactionObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\TransactionObject[] $transactionObject
     * @return \eBizCharge\ArrayType\ArrayOfTransactionObject
     */
    public function setTransactionObject(array $transactionObject = array())
    {
        // validation for constraint: array
        if ('' !== ($transactionObjectArrayErrorMessage = self::validateTransactionObjectForArrayConstraintsFromSetTransactionObject($transactionObject))) {
            throw new \InvalidArgumentException($transactionObjectArrayErrorMessage, __LINE__);
        }
        if (is_null($transactionObject) || (is_array($transactionObject) && empty($transactionObject))) {
            unset($this->TransactionObject);
        } else {
            $this->TransactionObject = $transactionObject;
        }
        return $this;
    }
    /**
     * Add item to TransactionObject value
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\TransactionObject $item
     * @return \eBizCharge\ArrayType\ArrayOfTransactionObject
     */
    public function addToTransactionObject(\eBizCharge\StructType\TransactionObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \eBizCharge\StructType\TransactionObject) {
            throw new \InvalidArgumentException(sprintf('The TransactionObject property can only contain items of type \eBizCharge\StructType\TransactionObject, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransactionObject[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \eBizCharge\StructType\TransactionObject|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \eBizCharge\StructType\TransactionObject|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \eBizCharge\StructType\TransactionObject|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \eBizCharge\StructType\TransactionObject|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \eBizCharge\StructType\TransactionObject|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransactionObject
     */
    public function getAttributeName()
    {
        return 'TransactionObject';
    }
}
