<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchTerms StructType
 * @subpackage Structs
 */
class SearchTerms extends AbstractStructBase
{
    /**
     * The start
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $start;
    /**
     * The limit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $limit;
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The termsInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $termsInternalId;
    /**
     * The termsId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $termsId;
    /**
     * The sort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sort;
    /**
     * Constructor method for SearchTerms
     * @uses SearchTerms::setStart()
     * @uses SearchTerms::setLimit()
     * @uses SearchTerms::setSecurityToken()
     * @uses SearchTerms::setTermsInternalId()
     * @uses SearchTerms::setTermsId()
     * @uses SearchTerms::setSort()
     * @param int $start
     * @param int $limit
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $termsInternalId
     * @param string $termsId
     * @param string $sort
     */
    public function __construct($start = null, $limit = null, \eBizCharge\StructType\SecurityToken $securityToken = null, $termsInternalId = null, $termsId = null, $sort = null)
    {
        $this
            ->setStart($start)
            ->setLimit($limit)
            ->setSecurityToken($securityToken)
            ->setTermsInternalId($termsInternalId)
            ->setTermsId($termsId)
            ->setSort($sort);
    }
    /**
     * Get start value
     * @return int
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param int $start
     * @return \eBizCharge\StructType\SearchTerms
     */
    public function setStart($start = null)
    {
        // validation for constraint: int
        if (!is_null($start) && !(is_int($start) || ctype_digit($start))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->start = $start;
        return $this;
    }
    /**
     * Get limit value
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \eBizCharge\StructType\SearchTerms
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\SearchTerms
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get termsInternalId value
     * @return string|null
     */
    public function getTermsInternalId()
    {
        return $this->termsInternalId;
    }
    /**
     * Set termsInternalId value
     * @param string $termsInternalId
     * @return \eBizCharge\StructType\SearchTerms
     */
    public function setTermsInternalId($termsInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($termsInternalId) && !is_string($termsInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsInternalId, true), gettype($termsInternalId)), __LINE__);
        }
        $this->termsInternalId = $termsInternalId;
        return $this;
    }
    /**
     * Get termsId value
     * @return string|null
     */
    public function getTermsId()
    {
        return $this->termsId;
    }
    /**
     * Set termsId value
     * @param string $termsId
     * @return \eBizCharge\StructType\SearchTerms
     */
    public function setTermsId($termsId = null)
    {
        // validation for constraint: string
        if (!is_null($termsId) && !is_string($termsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsId, true), gettype($termsId)), __LINE__);
        }
        $this->termsId = $termsId;
        return $this;
    }
    /**
     * Get sort value
     * @return string|null
     */
    public function getSort()
    {
        return $this->sort;
    }
    /**
     * Set sort value
     * @param string $sort
     * @return \eBizCharge\StructType\SearchTerms
     */
    public function setSort($sort = null)
    {
        // validation for constraint: string
        if (!is_null($sort) && !is_string($sort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->sort = $sort;
        return $this;
    }
}
