<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethodProfileCounts StructType
 * @subpackage Structs
 */
class PaymentMethodProfileCounts extends AbstractStructBase
{
    /**
     * The CreditCardsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreditCardsCount;
    /**
     * The BankAccountsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BankAccountsCount;
    /**
     * The CustomerInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\Customer
     */
    public $CustomerInformation;
    /**
     * Constructor method for PaymentMethodProfileCounts
     * @uses PaymentMethodProfileCounts::setCreditCardsCount()
     * @uses PaymentMethodProfileCounts::setBankAccountsCount()
     * @uses PaymentMethodProfileCounts::setCustomerInformation()
     * @param int $creditCardsCount
     * @param int $bankAccountsCount
     * @param \eBizCharge\StructType\Customer $customerInformation
     */
    public function __construct($creditCardsCount = null, $bankAccountsCount = null, \eBizCharge\StructType\Customer $customerInformation = null)
    {
        $this
            ->setCreditCardsCount($creditCardsCount)
            ->setBankAccountsCount($bankAccountsCount)
            ->setCustomerInformation($customerInformation);
    }
    /**
     * Get CreditCardsCount value
     * @return int
     */
    public function getCreditCardsCount()
    {
        return $this->CreditCardsCount;
    }
    /**
     * Set CreditCardsCount value
     * @param int $creditCardsCount
     * @return \eBizCharge\StructType\PaymentMethodProfileCounts
     */
    public function setCreditCardsCount($creditCardsCount = null)
    {
        // validation for constraint: int
        if (!is_null($creditCardsCount) && !(is_int($creditCardsCount) || ctype_digit($creditCardsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creditCardsCount, true), gettype($creditCardsCount)), __LINE__);
        }
        $this->CreditCardsCount = $creditCardsCount;
        return $this;
    }
    /**
     * Get BankAccountsCount value
     * @return int
     */
    public function getBankAccountsCount()
    {
        return $this->BankAccountsCount;
    }
    /**
     * Set BankAccountsCount value
     * @param int $bankAccountsCount
     * @return \eBizCharge\StructType\PaymentMethodProfileCounts
     */
    public function setBankAccountsCount($bankAccountsCount = null)
    {
        // validation for constraint: int
        if (!is_null($bankAccountsCount) && !(is_int($bankAccountsCount) || ctype_digit($bankAccountsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bankAccountsCount, true), gettype($bankAccountsCount)), __LINE__);
        }
        $this->BankAccountsCount = $bankAccountsCount;
        return $this;
    }
    /**
     * Get CustomerInformation value
     * @return \eBizCharge\StructType\Customer|null
     */
    public function getCustomerInformation()
    {
        return $this->CustomerInformation;
    }
    /**
     * Set CustomerInformation value
     * @param \eBizCharge\StructType\Customer $customerInformation
     * @return \eBizCharge\StructType\PaymentMethodProfileCounts
     */
    public function setCustomerInformation(\eBizCharge\StructType\Customer $customerInformation = null)
    {
        $this->CustomerInformation = $customerInformation;
        return $this;
    }
}
