<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The MerchantId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The SubCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubCustomerId;
    /**
     * The DivisionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DivisionId;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The InvoiceInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceInternalId;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDate;
    /**
     * The InvoiceDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDueDate;
    /**
     * The PoNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PoNum;
    /**
     * The SoNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SoNum;
    /**
     * The InvoiceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceAmount;
    /**
     * The AmountDue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AmountDue;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthCode;
    /**
     * The RefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefNum;
    /**
     * The Last4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last4;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethod;
    /**
     * The DatePaid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DatePaid;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaidAmount;
    /**
     * The PaymentInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentInternalId;
    /**
     * The ScheduledPaymentInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledPaymentInternalId;
    /**
     * The PaymentRequestDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentRequestDateTime;
    /**
     * The CustNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustNum;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentType;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeId;
    /**
     * The PaymentSourceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentSourceId;
    /**
     * The TransactionLookupKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionLookupKey;
    /**
     * The ExternalTxnId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalTxnId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The CustomerEmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerEmailAddress;
    /**
     * The DocumentTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTypeId;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerName;
    /**
     * Constructor method for Payment
     * @uses Payment::setMerchantId()
     * @uses Payment::setCustomerId()
     * @uses Payment::setSubCustomerId()
     * @uses Payment::setDivisionId()
     * @uses Payment::setInvoiceNumber()
     * @uses Payment::setInvoiceInternalId()
     * @uses Payment::setInvoiceDate()
     * @uses Payment::setInvoiceDueDate()
     * @uses Payment::setPoNum()
     * @uses Payment::setSoNum()
     * @uses Payment::setInvoiceAmount()
     * @uses Payment::setAmountDue()
     * @uses Payment::setCurrency()
     * @uses Payment::setAuthCode()
     * @uses Payment::setRefNum()
     * @uses Payment::setLast4()
     * @uses Payment::setPaymentMethod()
     * @uses Payment::setDatePaid()
     * @uses Payment::setPaidAmount()
     * @uses Payment::setPaymentInternalId()
     * @uses Payment::setScheduledPaymentInternalId()
     * @uses Payment::setPaymentRequestDateTime()
     * @uses Payment::setCustNum()
     * @uses Payment::setPaymentMethodId()
     * @uses Payment::setPaymentType()
     * @uses Payment::setTypeId()
     * @uses Payment::setPaymentSourceId()
     * @uses Payment::setTransactionLookupKey()
     * @uses Payment::setExternalTxnId()
     * @uses Payment::setDescription()
     * @uses Payment::setCustomerEmailAddress()
     * @uses Payment::setDocumentTypeId()
     * @uses Payment::setOrderId()
     * @uses Payment::setCustomerName()
     * @param string $merchantId
     * @param string $customerId
     * @param string $subCustomerId
     * @param string $divisionId
     * @param string $invoiceNumber
     * @param string $invoiceInternalId
     * @param string $invoiceDate
     * @param string $invoiceDueDate
     * @param string $poNum
     * @param string $soNum
     * @param string $invoiceAmount
     * @param string $amountDue
     * @param string $currency
     * @param string $authCode
     * @param string $refNum
     * @param string $last4
     * @param string $paymentMethod
     * @param string $datePaid
     * @param string $paidAmount
     * @param string $paymentInternalId
     * @param string $scheduledPaymentInternalId
     * @param string $paymentRequestDateTime
     * @param string $custNum
     * @param string $paymentMethodId
     * @param string $paymentType
     * @param string $typeId
     * @param string $paymentSourceId
     * @param string $transactionLookupKey
     * @param string $externalTxnId
     * @param string $description
     * @param string $customerEmailAddress
     * @param string $documentTypeId
     * @param string $orderId
     * @param string $customerName
     */
    public function __construct($merchantId = null, $customerId = null, $subCustomerId = null, $divisionId = null, $invoiceNumber = null, $invoiceInternalId = null, $invoiceDate = null, $invoiceDueDate = null, $poNum = null, $soNum = null, $invoiceAmount = null, $amountDue = null, $currency = null, $authCode = null, $refNum = null, $last4 = null, $paymentMethod = null, $datePaid = null, $paidAmount = null, $paymentInternalId = null, $scheduledPaymentInternalId = null, $paymentRequestDateTime = null, $custNum = null, $paymentMethodId = null, $paymentType = null, $typeId = null, $paymentSourceId = null, $transactionLookupKey = null, $externalTxnId = null, $description = null, $customerEmailAddress = null, $documentTypeId = null, $orderId = null, $customerName = null)
    {
        $this
            ->setMerchantId($merchantId)
            ->setCustomerId($customerId)
            ->setSubCustomerId($subCustomerId)
            ->setDivisionId($divisionId)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceInternalId($invoiceInternalId)
            ->setInvoiceDate($invoiceDate)
            ->setInvoiceDueDate($invoiceDueDate)
            ->setPoNum($poNum)
            ->setSoNum($soNum)
            ->setInvoiceAmount($invoiceAmount)
            ->setAmountDue($amountDue)
            ->setCurrency($currency)
            ->setAuthCode($authCode)
            ->setRefNum($refNum)
            ->setLast4($last4)
            ->setPaymentMethod($paymentMethod)
            ->setDatePaid($datePaid)
            ->setPaidAmount($paidAmount)
            ->setPaymentInternalId($paymentInternalId)
            ->setScheduledPaymentInternalId($scheduledPaymentInternalId)
            ->setPaymentRequestDateTime($paymentRequestDateTime)
            ->setCustNum($custNum)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentType($paymentType)
            ->setTypeId($typeId)
            ->setPaymentSourceId($paymentSourceId)
            ->setTransactionLookupKey($transactionLookupKey)
            ->setExternalTxnId($externalTxnId)
            ->setDescription($description)
            ->setCustomerEmailAddress($customerEmailAddress)
            ->setDocumentTypeId($documentTypeId)
            ->setOrderId($orderId)
            ->setCustomerName($customerName);
    }
    /**
     * Get MerchantId value
     * @return string|null
     */
    public function getMerchantId()
    {
        return $this->MerchantId;
    }
    /**
     * Set MerchantId value
     * @param string $merchantId
     * @return \eBizCharge\StructType\Payment
     */
    public function setMerchantId($merchantId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantId) && !is_string($merchantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantId, true), gettype($merchantId)), __LINE__);
        }
        $this->MerchantId = $merchantId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\Payment
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SubCustomerId value
     * @return string|null
     */
    public function getSubCustomerId()
    {
        return $this->SubCustomerId;
    }
    /**
     * Set SubCustomerId value
     * @param string $subCustomerId
     * @return \eBizCharge\StructType\Payment
     */
    public function setSubCustomerId($subCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($subCustomerId) && !is_string($subCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCustomerId, true), gettype($subCustomerId)), __LINE__);
        }
        $this->SubCustomerId = $subCustomerId;
        return $this;
    }
    /**
     * Get DivisionId value
     * @return string|null
     */
    public function getDivisionId()
    {
        return $this->DivisionId;
    }
    /**
     * Set DivisionId value
     * @param string $divisionId
     * @return \eBizCharge\StructType\Payment
     */
    public function setDivisionId($divisionId = null)
    {
        // validation for constraint: string
        if (!is_null($divisionId) && !is_string($divisionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($divisionId, true), gettype($divisionId)), __LINE__);
        }
        $this->DivisionId = $divisionId;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \eBizCharge\StructType\Payment
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceInternalId value
     * @return string|null
     */
    public function getInvoiceInternalId()
    {
        return $this->InvoiceInternalId;
    }
    /**
     * Set InvoiceInternalId value
     * @param string $invoiceInternalId
     * @return \eBizCharge\StructType\Payment
     */
    public function setInvoiceInternalId($invoiceInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceInternalId) && !is_string($invoiceInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceInternalId, true), gettype($invoiceInternalId)), __LINE__);
        }
        $this->InvoiceInternalId = $invoiceInternalId;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \eBizCharge\StructType\Payment
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get InvoiceDueDate value
     * @return string|null
     */
    public function getInvoiceDueDate()
    {
        return $this->InvoiceDueDate;
    }
    /**
     * Set InvoiceDueDate value
     * @param string $invoiceDueDate
     * @return \eBizCharge\StructType\Payment
     */
    public function setInvoiceDueDate($invoiceDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDueDate) && !is_string($invoiceDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDueDate, true), gettype($invoiceDueDate)), __LINE__);
        }
        $this->InvoiceDueDate = $invoiceDueDate;
        return $this;
    }
    /**
     * Get PoNum value
     * @return string|null
     */
    public function getPoNum()
    {
        return $this->PoNum;
    }
    /**
     * Set PoNum value
     * @param string $poNum
     * @return \eBizCharge\StructType\Payment
     */
    public function setPoNum($poNum = null)
    {
        // validation for constraint: string
        if (!is_null($poNum) && !is_string($poNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poNum, true), gettype($poNum)), __LINE__);
        }
        $this->PoNum = $poNum;
        return $this;
    }
    /**
     * Get SoNum value
     * @return string|null
     */
    public function getSoNum()
    {
        return $this->SoNum;
    }
    /**
     * Set SoNum value
     * @param string $soNum
     * @return \eBizCharge\StructType\Payment
     */
    public function setSoNum($soNum = null)
    {
        // validation for constraint: string
        if (!is_null($soNum) && !is_string($soNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soNum, true), gettype($soNum)), __LINE__);
        }
        $this->SoNum = $soNum;
        return $this;
    }
    /**
     * Get InvoiceAmount value
     * @return string|null
     */
    public function getInvoiceAmount()
    {
        return $this->InvoiceAmount;
    }
    /**
     * Set InvoiceAmount value
     * @param string $invoiceAmount
     * @return \eBizCharge\StructType\Payment
     */
    public function setInvoiceAmount($invoiceAmount = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceAmount) && !is_string($invoiceAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceAmount, true), gettype($invoiceAmount)), __LINE__);
        }
        $this->InvoiceAmount = $invoiceAmount;
        return $this;
    }
    /**
     * Get AmountDue value
     * @return string|null
     */
    public function getAmountDue()
    {
        return $this->AmountDue;
    }
    /**
     * Set AmountDue value
     * @param string $amountDue
     * @return \eBizCharge\StructType\Payment
     */
    public function setAmountDue($amountDue = null)
    {
        // validation for constraint: string
        if (!is_null($amountDue) && !is_string($amountDue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountDue, true), gettype($amountDue)), __LINE__);
        }
        $this->AmountDue = $amountDue;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \eBizCharge\StructType\Payment
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \eBizCharge\StructType\Payment
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get RefNum value
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->RefNum;
    }
    /**
     * Set RefNum value
     * @param string $refNum
     * @return \eBizCharge\StructType\Payment
     */
    public function setRefNum($refNum = null)
    {
        // validation for constraint: string
        if (!is_null($refNum) && !is_string($refNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNum, true), gettype($refNum)), __LINE__);
        }
        $this->RefNum = $refNum;
        return $this;
    }
    /**
     * Get Last4 value
     * @return string|null
     */
    public function getLast4()
    {
        return $this->Last4;
    }
    /**
     * Set Last4 value
     * @param string $last4
     * @return \eBizCharge\StructType\Payment
     */
    public function setLast4($last4 = null)
    {
        // validation for constraint: string
        if (!is_null($last4) && !is_string($last4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last4, true), gettype($last4)), __LINE__);
        }
        $this->Last4 = $last4;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param string $paymentMethod
     * @return \eBizCharge\StructType\Payment
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get DatePaid value
     * @return string|null
     */
    public function getDatePaid()
    {
        return $this->DatePaid;
    }
    /**
     * Set DatePaid value
     * @param string $datePaid
     * @return \eBizCharge\StructType\Payment
     */
    public function setDatePaid($datePaid = null)
    {
        // validation for constraint: string
        if (!is_null($datePaid) && !is_string($datePaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datePaid, true), gettype($datePaid)), __LINE__);
        }
        $this->DatePaid = $datePaid;
        return $this;
    }
    /**
     * Get PaidAmount value
     * @return string|null
     */
    public function getPaidAmount()
    {
        return $this->PaidAmount;
    }
    /**
     * Set PaidAmount value
     * @param string $paidAmount
     * @return \eBizCharge\StructType\Payment
     */
    public function setPaidAmount($paidAmount = null)
    {
        // validation for constraint: string
        if (!is_null($paidAmount) && !is_string($paidAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paidAmount, true), gettype($paidAmount)), __LINE__);
        }
        $this->PaidAmount = $paidAmount;
        return $this;
    }
    /**
     * Get PaymentInternalId value
     * @return string|null
     */
    public function getPaymentInternalId()
    {
        return $this->PaymentInternalId;
    }
    /**
     * Set PaymentInternalId value
     * @param string $paymentInternalId
     * @return \eBizCharge\StructType\Payment
     */
    public function setPaymentInternalId($paymentInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInternalId) && !is_string($paymentInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInternalId, true), gettype($paymentInternalId)), __LINE__);
        }
        $this->PaymentInternalId = $paymentInternalId;
        return $this;
    }
    /**
     * Get ScheduledPaymentInternalId value
     * @return string|null
     */
    public function getScheduledPaymentInternalId()
    {
        return $this->ScheduledPaymentInternalId;
    }
    /**
     * Set ScheduledPaymentInternalId value
     * @param string $scheduledPaymentInternalId
     * @return \eBizCharge\StructType\Payment
     */
    public function setScheduledPaymentInternalId($scheduledPaymentInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledPaymentInternalId) && !is_string($scheduledPaymentInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduledPaymentInternalId, true), gettype($scheduledPaymentInternalId)), __LINE__);
        }
        $this->ScheduledPaymentInternalId = $scheduledPaymentInternalId;
        return $this;
    }
    /**
     * Get PaymentRequestDateTime value
     * @return string|null
     */
    public function getPaymentRequestDateTime()
    {
        return $this->PaymentRequestDateTime;
    }
    /**
     * Set PaymentRequestDateTime value
     * @param string $paymentRequestDateTime
     * @return \eBizCharge\StructType\Payment
     */
    public function setPaymentRequestDateTime($paymentRequestDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRequestDateTime) && !is_string($paymentRequestDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRequestDateTime, true), gettype($paymentRequestDateTime)), __LINE__);
        }
        $this->PaymentRequestDateTime = $paymentRequestDateTime;
        return $this;
    }
    /**
     * Get CustNum value
     * @return string|null
     */
    public function getCustNum()
    {
        return $this->CustNum;
    }
    /**
     * Set CustNum value
     * @param string $custNum
     * @return \eBizCharge\StructType\Payment
     */
    public function setCustNum($custNum = null)
    {
        // validation for constraint: string
        if (!is_null($custNum) && !is_string($custNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custNum, true), gettype($custNum)), __LINE__);
        }
        $this->CustNum = $custNum;
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->PaymentMethodId;
    }
    /**
     * Set PaymentMethodId value
     * @param string $paymentMethodId
     * @return \eBizCharge\StructType\Payment
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        $this->PaymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \eBizCharge\StructType\Payment
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get TypeId value
     * @return string|null
     */
    public function getTypeId()
    {
        return $this->TypeId;
    }
    /**
     * Set TypeId value
     * @param string $typeId
     * @return \eBizCharge\StructType\Payment
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        $this->TypeId = $typeId;
        return $this;
    }
    /**
     * Get PaymentSourceId value
     * @return string|null
     */
    public function getPaymentSourceId()
    {
        return $this->PaymentSourceId;
    }
    /**
     * Set PaymentSourceId value
     * @param string $paymentSourceId
     * @return \eBizCharge\StructType\Payment
     */
    public function setPaymentSourceId($paymentSourceId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSourceId) && !is_string($paymentSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSourceId, true), gettype($paymentSourceId)), __LINE__);
        }
        $this->PaymentSourceId = $paymentSourceId;
        return $this;
    }
    /**
     * Get TransactionLookupKey value
     * @return string|null
     */
    public function getTransactionLookupKey()
    {
        return $this->TransactionLookupKey;
    }
    /**
     * Set TransactionLookupKey value
     * @param string $transactionLookupKey
     * @return \eBizCharge\StructType\Payment
     */
    public function setTransactionLookupKey($transactionLookupKey = null)
    {
        // validation for constraint: string
        if (!is_null($transactionLookupKey) && !is_string($transactionLookupKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionLookupKey, true), gettype($transactionLookupKey)), __LINE__);
        }
        $this->TransactionLookupKey = $transactionLookupKey;
        return $this;
    }
    /**
     * Get ExternalTxnId value
     * @return string|null
     */
    public function getExternalTxnId()
    {
        return $this->ExternalTxnId;
    }
    /**
     * Set ExternalTxnId value
     * @param string $externalTxnId
     * @return \eBizCharge\StructType\Payment
     */
    public function setExternalTxnId($externalTxnId = null)
    {
        // validation for constraint: string
        if (!is_null($externalTxnId) && !is_string($externalTxnId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalTxnId, true), gettype($externalTxnId)), __LINE__);
        }
        $this->ExternalTxnId = $externalTxnId;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \eBizCharge\StructType\Payment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CustomerEmailAddress value
     * @return string|null
     */
    public function getCustomerEmailAddress()
    {
        return $this->CustomerEmailAddress;
    }
    /**
     * Set CustomerEmailAddress value
     * @param string $customerEmailAddress
     * @return \eBizCharge\StructType\Payment
     */
    public function setCustomerEmailAddress($customerEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($customerEmailAddress) && !is_string($customerEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerEmailAddress, true), gettype($customerEmailAddress)), __LINE__);
        }
        $this->CustomerEmailAddress = $customerEmailAddress;
        return $this;
    }
    /**
     * Get DocumentTypeId value
     * @return string|null
     */
    public function getDocumentTypeId()
    {
        return $this->DocumentTypeId;
    }
    /**
     * Set DocumentTypeId value
     * @param string $documentTypeId
     * @return \eBizCharge\StructType\Payment
     */
    public function setDocumentTypeId($documentTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeId) && !is_string($documentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeId, true), gettype($documentTypeId)), __LINE__);
        }
        $this->DocumentTypeId = $documentTypeId;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \eBizCharge\StructType\Payment
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get CustomerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->CustomerName;
    }
    /**
     * Set CustomerName value
     * @param string $customerName
     * @return \eBizCharge\StructType\Payment
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerName, true), gettype($customerName)), __LINE__);
        }
        $this->CustomerName = $customerName;
        return $this;
    }
}
