<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUserData StructType
 * @subpackage Structs
 */
class UpdateUserData extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The userInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userInternalId;
    /**
     * The userData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\UserData
     */
    public $userData;
    /**
     * Constructor method for UpdateUserData
     * @uses UpdateUserData::setSecurityToken()
     * @uses UpdateUserData::setUserInternalId()
     * @uses UpdateUserData::setUserData()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $userInternalId
     * @param \eBizCharge\StructType\UserData $userData
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $userInternalId = null, \eBizCharge\StructType\UserData $userData = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setUserInternalId($userInternalId)
            ->setUserData($userData);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\UpdateUserData
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get userInternalId value
     * @return string|null
     */
    public function getUserInternalId()
    {
        return $this->userInternalId;
    }
    /**
     * Set userInternalId value
     * @param string $userInternalId
     * @return \eBizCharge\StructType\UpdateUserData
     */
    public function setUserInternalId($userInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($userInternalId) && !is_string($userInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userInternalId, true), gettype($userInternalId)), __LINE__);
        }
        $this->userInternalId = $userInternalId;
        return $this;
    }
    /**
     * Get userData value
     * @return \eBizCharge\StructType\UserData|null
     */
    public function getUserData()
    {
        return $this->userData;
    }
    /**
     * Set userData value
     * @param \eBizCharge\StructType\UserData $userData
     * @return \eBizCharge\StructType\UpdateUserData
     */
    public function setUserData(\eBizCharge\StructType\UserData $userData = null)
    {
        $this->userData = $userData;
        return $this;
    }
}
