<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Surcharge StructType
 * @subpackage Structs
 */
class Surcharge extends AbstractStructBase
{
    /**
     * The IsApplied
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsApplied;
    /**
     * The SurchargeInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurchargeInternalId;
    /**
     * The AuthCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthCode;
    /**
     * The RefNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefNum;
    /**
     * The Last4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last4;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The DatePaid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DatePaid;
    /**
     * The TotalSurchargeAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TotalSurchargeAmount;
    /**
     * The PaymentInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentInternalId;
    /**
     * The CustomerToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerToken;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentType;
    /**
     * The PaymentSourceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentSourceId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The SurchargePercentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurchargePercentage;
    /**
     * The TotalPaidAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TotalPaidAmount;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The PaidDocuments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfPaidDocument
     */
    public $PaidDocuments;
    /**
     * The DateApplied
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateApplied;
    /**
     * The SurchargeCountryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurchargeCountryId;
    /**
     * The SurchargeTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurchargeTypeId;
    /**
     * The SurchargeCustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfEbizCustomField
     */
    public $SurchargeCustomFields;
    /**
     * Constructor method for Surcharge
     * @uses Surcharge::setIsApplied()
     * @uses Surcharge::setSurchargeInternalId()
     * @uses Surcharge::setAuthCode()
     * @uses Surcharge::setRefNum()
     * @uses Surcharge::setLast4()
     * @uses Surcharge::setPaymentMethodType()
     * @uses Surcharge::setDatePaid()
     * @uses Surcharge::setTotalSurchargeAmount()
     * @uses Surcharge::setPaymentInternalId()
     * @uses Surcharge::setCustomerToken()
     * @uses Surcharge::setPaymentMethodId()
     * @uses Surcharge::setPaymentType()
     * @uses Surcharge::setPaymentSourceId()
     * @uses Surcharge::setDescription()
     * @uses Surcharge::setSurchargePercentage()
     * @uses Surcharge::setTotalPaidAmount()
     * @uses Surcharge::setCurrency()
     * @uses Surcharge::setPaidDocuments()
     * @uses Surcharge::setDateApplied()
     * @uses Surcharge::setSurchargeCountryId()
     * @uses Surcharge::setSurchargeTypeId()
     * @uses Surcharge::setSurchargeCustomFields()
     * @param bool $isApplied
     * @param string $surchargeInternalId
     * @param string $authCode
     * @param string $refNum
     * @param string $last4
     * @param string $paymentMethodType
     * @param string $datePaid
     * @param string $totalSurchargeAmount
     * @param string $paymentInternalId
     * @param string $customerToken
     * @param string $paymentMethodId
     * @param string $paymentType
     * @param string $paymentSourceId
     * @param string $description
     * @param string $surchargePercentage
     * @param string $totalPaidAmount
     * @param string $currency
     * @param \eBizCharge\ArrayType\ArrayOfPaidDocument $paidDocuments
     * @param string $dateApplied
     * @param string $surchargeCountryId
     * @param string $surchargeTypeId
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $surchargeCustomFields
     */
    public function __construct($isApplied = null, $surchargeInternalId = null, $authCode = null, $refNum = null, $last4 = null, $paymentMethodType = null, $datePaid = null, $totalSurchargeAmount = null, $paymentInternalId = null, $customerToken = null, $paymentMethodId = null, $paymentType = null, $paymentSourceId = null, $description = null, $surchargePercentage = null, $totalPaidAmount = null, $currency = null, \eBizCharge\ArrayType\ArrayOfPaidDocument $paidDocuments = null, $dateApplied = null, $surchargeCountryId = null, $surchargeTypeId = null, \eBizCharge\ArrayType\ArrayOfEbizCustomField $surchargeCustomFields = null)
    {
        $this
            ->setIsApplied($isApplied)
            ->setSurchargeInternalId($surchargeInternalId)
            ->setAuthCode($authCode)
            ->setRefNum($refNum)
            ->setLast4($last4)
            ->setPaymentMethodType($paymentMethodType)
            ->setDatePaid($datePaid)
            ->setTotalSurchargeAmount($totalSurchargeAmount)
            ->setPaymentInternalId($paymentInternalId)
            ->setCustomerToken($customerToken)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentType($paymentType)
            ->setPaymentSourceId($paymentSourceId)
            ->setDescription($description)
            ->setSurchargePercentage($surchargePercentage)
            ->setTotalPaidAmount($totalPaidAmount)
            ->setCurrency($currency)
            ->setPaidDocuments($paidDocuments)
            ->setDateApplied($dateApplied)
            ->setSurchargeCountryId($surchargeCountryId)
            ->setSurchargeTypeId($surchargeTypeId)
            ->setSurchargeCustomFields($surchargeCustomFields);
    }
    /**
     * Get IsApplied value
     * @return bool
     */
    public function getIsApplied()
    {
        return $this->IsApplied;
    }
    /**
     * Set IsApplied value
     * @param bool $isApplied
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setIsApplied($isApplied = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApplied) && !is_bool($isApplied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isApplied, true), gettype($isApplied)), __LINE__);
        }
        $this->IsApplied = $isApplied;
        return $this;
    }
    /**
     * Get SurchargeInternalId value
     * @return string|null
     */
    public function getSurchargeInternalId()
    {
        return $this->SurchargeInternalId;
    }
    /**
     * Set SurchargeInternalId value
     * @param string $surchargeInternalId
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setSurchargeInternalId($surchargeInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($surchargeInternalId) && !is_string($surchargeInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surchargeInternalId, true), gettype($surchargeInternalId)), __LINE__);
        }
        $this->SurchargeInternalId = $surchargeInternalId;
        return $this;
    }
    /**
     * Get AuthCode value
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->AuthCode;
    }
    /**
     * Set AuthCode value
     * @param string $authCode
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setAuthCode($authCode = null)
    {
        // validation for constraint: string
        if (!is_null($authCode) && !is_string($authCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authCode, true), gettype($authCode)), __LINE__);
        }
        $this->AuthCode = $authCode;
        return $this;
    }
    /**
     * Get RefNum value
     * @return string|null
     */
    public function getRefNum()
    {
        return $this->RefNum;
    }
    /**
     * Set RefNum value
     * @param string $refNum
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setRefNum($refNum = null)
    {
        // validation for constraint: string
        if (!is_null($refNum) && !is_string($refNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNum, true), gettype($refNum)), __LINE__);
        }
        $this->RefNum = $refNum;
        return $this;
    }
    /**
     * Get Last4 value
     * @return string|null
     */
    public function getLast4()
    {
        return $this->Last4;
    }
    /**
     * Set Last4 value
     * @param string $last4
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setLast4($last4 = null)
    {
        // validation for constraint: string
        if (!is_null($last4) && !is_string($last4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last4, true), gettype($last4)), __LINE__);
        }
        $this->Last4 = $last4;
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return $this->PaymentMethodType;
    }
    /**
     * Set PaymentMethodType value
     * @param string $paymentMethodType
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodType) && !is_string($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodType, true), gettype($paymentMethodType)), __LINE__);
        }
        $this->PaymentMethodType = $paymentMethodType;
        return $this;
    }
    /**
     * Get DatePaid value
     * @return string|null
     */
    public function getDatePaid()
    {
        return $this->DatePaid;
    }
    /**
     * Set DatePaid value
     * @param string $datePaid
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setDatePaid($datePaid = null)
    {
        // validation for constraint: string
        if (!is_null($datePaid) && !is_string($datePaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datePaid, true), gettype($datePaid)), __LINE__);
        }
        $this->DatePaid = $datePaid;
        return $this;
    }
    /**
     * Get TotalSurchargeAmount value
     * @return string|null
     */
    public function getTotalSurchargeAmount()
    {
        return $this->TotalSurchargeAmount;
    }
    /**
     * Set TotalSurchargeAmount value
     * @param string $totalSurchargeAmount
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setTotalSurchargeAmount($totalSurchargeAmount = null)
    {
        // validation for constraint: string
        if (!is_null($totalSurchargeAmount) && !is_string($totalSurchargeAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalSurchargeAmount, true), gettype($totalSurchargeAmount)), __LINE__);
        }
        $this->TotalSurchargeAmount = $totalSurchargeAmount;
        return $this;
    }
    /**
     * Get PaymentInternalId value
     * @return string|null
     */
    public function getPaymentInternalId()
    {
        return $this->PaymentInternalId;
    }
    /**
     * Set PaymentInternalId value
     * @param string $paymentInternalId
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setPaymentInternalId($paymentInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInternalId) && !is_string($paymentInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInternalId, true), gettype($paymentInternalId)), __LINE__);
        }
        $this->PaymentInternalId = $paymentInternalId;
        return $this;
    }
    /**
     * Get CustomerToken value
     * @return string|null
     */
    public function getCustomerToken()
    {
        return $this->CustomerToken;
    }
    /**
     * Set CustomerToken value
     * @param string $customerToken
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setCustomerToken($customerToken = null)
    {
        // validation for constraint: string
        if (!is_null($customerToken) && !is_string($customerToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerToken, true), gettype($customerToken)), __LINE__);
        }
        $this->CustomerToken = $customerToken;
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->PaymentMethodId;
    }
    /**
     * Set PaymentMethodId value
     * @param string $paymentMethodId
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        $this->PaymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get PaymentSourceId value
     * @return string|null
     */
    public function getPaymentSourceId()
    {
        return $this->PaymentSourceId;
    }
    /**
     * Set PaymentSourceId value
     * @param string $paymentSourceId
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setPaymentSourceId($paymentSourceId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSourceId) && !is_string($paymentSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSourceId, true), gettype($paymentSourceId)), __LINE__);
        }
        $this->PaymentSourceId = $paymentSourceId;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get SurchargePercentage value
     * @return string|null
     */
    public function getSurchargePercentage()
    {
        return $this->SurchargePercentage;
    }
    /**
     * Set SurchargePercentage value
     * @param string $surchargePercentage
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setSurchargePercentage($surchargePercentage = null)
    {
        // validation for constraint: string
        if (!is_null($surchargePercentage) && !is_string($surchargePercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surchargePercentage, true), gettype($surchargePercentage)), __LINE__);
        }
        $this->SurchargePercentage = $surchargePercentage;
        return $this;
    }
    /**
     * Get TotalPaidAmount value
     * @return string|null
     */
    public function getTotalPaidAmount()
    {
        return $this->TotalPaidAmount;
    }
    /**
     * Set TotalPaidAmount value
     * @param string $totalPaidAmount
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setTotalPaidAmount($totalPaidAmount = null)
    {
        // validation for constraint: string
        if (!is_null($totalPaidAmount) && !is_string($totalPaidAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalPaidAmount, true), gettype($totalPaidAmount)), __LINE__);
        }
        $this->TotalPaidAmount = $totalPaidAmount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get PaidDocuments value
     * @return \eBizCharge\ArrayType\ArrayOfPaidDocument|null
     */
    public function getPaidDocuments()
    {
        return $this->PaidDocuments;
    }
    /**
     * Set PaidDocuments value
     * @param \eBizCharge\ArrayType\ArrayOfPaidDocument $paidDocuments
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setPaidDocuments(\eBizCharge\ArrayType\ArrayOfPaidDocument $paidDocuments = null)
    {
        $this->PaidDocuments = $paidDocuments;
        return $this;
    }
    /**
     * Get DateApplied value
     * @return string|null
     */
    public function getDateApplied()
    {
        return $this->DateApplied;
    }
    /**
     * Set DateApplied value
     * @param string $dateApplied
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setDateApplied($dateApplied = null)
    {
        // validation for constraint: string
        if (!is_null($dateApplied) && !is_string($dateApplied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateApplied, true), gettype($dateApplied)), __LINE__);
        }
        $this->DateApplied = $dateApplied;
        return $this;
    }
    /**
     * Get SurchargeCountryId value
     * @return string|null
     */
    public function getSurchargeCountryId()
    {
        return $this->SurchargeCountryId;
    }
    /**
     * Set SurchargeCountryId value
     * @param string $surchargeCountryId
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setSurchargeCountryId($surchargeCountryId = null)
    {
        // validation for constraint: string
        if (!is_null($surchargeCountryId) && !is_string($surchargeCountryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surchargeCountryId, true), gettype($surchargeCountryId)), __LINE__);
        }
        $this->SurchargeCountryId = $surchargeCountryId;
        return $this;
    }
    /**
     * Get SurchargeTypeId value
     * @return string|null
     */
    public function getSurchargeTypeId()
    {
        return $this->SurchargeTypeId;
    }
    /**
     * Set SurchargeTypeId value
     * @param string $surchargeTypeId
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setSurchargeTypeId($surchargeTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($surchargeTypeId) && !is_string($surchargeTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surchargeTypeId, true), gettype($surchargeTypeId)), __LINE__);
        }
        $this->SurchargeTypeId = $surchargeTypeId;
        return $this;
    }
    /**
     * Get SurchargeCustomFields value
     * @return \eBizCharge\ArrayType\ArrayOfEbizCustomField|null
     */
    public function getSurchargeCustomFields()
    {
        return $this->SurchargeCustomFields;
    }
    /**
     * Set SurchargeCustomFields value
     * @param \eBizCharge\ArrayType\ArrayOfEbizCustomField $surchargeCustomFields
     * @return \eBizCharge\StructType\Surcharge
     */
    public function setSurchargeCustomFields(\eBizCharge\ArrayType\ArrayOfEbizCustomField $surchargeCustomFields = null)
    {
        $this->SurchargeCustomFields = $surchargeCustomFields;
        return $this;
    }
}
