<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduleRecurringPayment StructType
 * @subpackage Structs
 */
class ScheduleRecurringPayment extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The customerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerInternalId;
    /**
     * The paymentMethodProfileId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paymentMethodProfileId;
    /**
     * The recurringBilling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\RecurringBilling
     */
    public $recurringBilling;
    /**
     * Constructor method for ScheduleRecurringPayment
     * @uses ScheduleRecurringPayment::setSecurityToken()
     * @uses ScheduleRecurringPayment::setCustomerInternalId()
     * @uses ScheduleRecurringPayment::setPaymentMethodProfileId()
     * @uses ScheduleRecurringPayment::setRecurringBilling()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $customerInternalId
     * @param string $paymentMethodProfileId
     * @param \eBizCharge\StructType\RecurringBilling $recurringBilling
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $customerInternalId = null, $paymentMethodProfileId = null, \eBizCharge\StructType\RecurringBilling $recurringBilling = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setCustomerInternalId($customerInternalId)
            ->setPaymentMethodProfileId($paymentMethodProfileId)
            ->setRecurringBilling($recurringBilling);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\ScheduleRecurringPayment
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get customerInternalId value
     * @return string|null
     */
    public function getCustomerInternalId()
    {
        return $this->customerInternalId;
    }
    /**
     * Set customerInternalId value
     * @param string $customerInternalId
     * @return \eBizCharge\StructType\ScheduleRecurringPayment
     */
    public function setCustomerInternalId($customerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($customerInternalId) && !is_string($customerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerInternalId, true), gettype($customerInternalId)), __LINE__);
        }
        $this->customerInternalId = $customerInternalId;
        return $this;
    }
    /**
     * Get paymentMethodProfileId value
     * @return string|null
     */
    public function getPaymentMethodProfileId()
    {
        return $this->paymentMethodProfileId;
    }
    /**
     * Set paymentMethodProfileId value
     * @param string $paymentMethodProfileId
     * @return \eBizCharge\StructType\ScheduleRecurringPayment
     */
    public function setPaymentMethodProfileId($paymentMethodProfileId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodProfileId) && !is_string($paymentMethodProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodProfileId, true), gettype($paymentMethodProfileId)), __LINE__);
        }
        $this->paymentMethodProfileId = $paymentMethodProfileId;
        return $this;
    }
    /**
     * Get recurringBilling value
     * @return \eBizCharge\StructType\RecurringBilling|null
     */
    public function getRecurringBilling()
    {
        return $this->recurringBilling;
    }
    /**
     * Set recurringBilling value
     * @param \eBizCharge\StructType\RecurringBilling $recurringBilling
     * @return \eBizCharge\StructType\ScheduleRecurringPayment
     */
    public function setRecurringBilling(\eBizCharge\StructType\RecurringBilling $recurringBilling = null)
    {
        $this->recurringBilling = $recurringBilling;
        return $this;
    }
}
