<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMerchantData StructType
 * @subpackage Structs
 */
class GetMerchantData extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The merchantInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $merchantInternalId;
    /**
     * Constructor method for GetMerchantData
     * @uses GetMerchantData::setSecurityToken()
     * @uses GetMerchantData::setMerchantInternalId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $merchantInternalId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $merchantInternalId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setMerchantInternalId($merchantInternalId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\GetMerchantData
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get merchantInternalId value
     * @return string|null
     */
    public function getMerchantInternalId()
    {
        return $this->merchantInternalId;
    }
    /**
     * Set merchantInternalId value
     * @param string $merchantInternalId
     * @return \eBizCharge\StructType\GetMerchantData
     */
    public function setMerchantInternalId($merchantInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantInternalId) && !is_string($merchantInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantInternalId, true), gettype($merchantInternalId)), __LINE__);
        }
        $this->merchantInternalId = $merchantInternalId;
        return $this;
    }
}
