<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardData StructType
 * @subpackage Structs
 */
class CreditCardData extends AbstractStructBase
{
    /**
     * The InternalCardAuth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $InternalCardAuth;
    /**
     * The CardPresent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CardPresent;
    /**
     * The CAVV
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CAVV;
    /**
     * The Pares
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Pares;
    /**
     * The MagSupport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MagSupport;
    /**
     * The MagStripe
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MagStripe;
    /**
     * The ECI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ECI;
    /**
     * The DUKPT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DUKPT;
    /**
     * The XID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $XID;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardType;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardNumber;
    /**
     * The CardExpiration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardExpiration;
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardCode;
    /**
     * The AvsZip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvsZip;
    /**
     * The AvsStreet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvsStreet;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Signature;
    /**
     * The TermType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TermType;
    /**
     * Constructor method for CreditCardData
     * @uses CreditCardData::setInternalCardAuth()
     * @uses CreditCardData::setCardPresent()
     * @uses CreditCardData::setCAVV()
     * @uses CreditCardData::setPares()
     * @uses CreditCardData::setMagSupport()
     * @uses CreditCardData::setMagStripe()
     * @uses CreditCardData::setECI()
     * @uses CreditCardData::setDUKPT()
     * @uses CreditCardData::setXID()
     * @uses CreditCardData::setCardType()
     * @uses CreditCardData::setCardNumber()
     * @uses CreditCardData::setCardExpiration()
     * @uses CreditCardData::setCardCode()
     * @uses CreditCardData::setAvsZip()
     * @uses CreditCardData::setAvsStreet()
     * @uses CreditCardData::setSignature()
     * @uses CreditCardData::setTermType()
     * @param bool $internalCardAuth
     * @param bool $cardPresent
     * @param string $cAVV
     * @param string $pares
     * @param string $magSupport
     * @param string $magStripe
     * @param string $eCI
     * @param string $dUKPT
     * @param string $xID
     * @param string $cardType
     * @param string $cardNumber
     * @param string $cardExpiration
     * @param string $cardCode
     * @param string $avsZip
     * @param string $avsStreet
     * @param string $signature
     * @param string $termType
     */
    public function __construct($internalCardAuth = null, $cardPresent = null, $cAVV = null, $pares = null, $magSupport = null, $magStripe = null, $eCI = null, $dUKPT = null, $xID = null, $cardType = null, $cardNumber = null, $cardExpiration = null, $cardCode = null, $avsZip = null, $avsStreet = null, $signature = null, $termType = null)
    {
        $this
            ->setInternalCardAuth($internalCardAuth)
            ->setCardPresent($cardPresent)
            ->setCAVV($cAVV)
            ->setPares($pares)
            ->setMagSupport($magSupport)
            ->setMagStripe($magStripe)
            ->setECI($eCI)
            ->setDUKPT($dUKPT)
            ->setXID($xID)
            ->setCardType($cardType)
            ->setCardNumber($cardNumber)
            ->setCardExpiration($cardExpiration)
            ->setCardCode($cardCode)
            ->setAvsZip($avsZip)
            ->setAvsStreet($avsStreet)
            ->setSignature($signature)
            ->setTermType($termType);
    }
    /**
     * Get InternalCardAuth value
     * @return bool
     */
    public function getInternalCardAuth()
    {
        return $this->InternalCardAuth;
    }
    /**
     * Set InternalCardAuth value
     * @param bool $internalCardAuth
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setInternalCardAuth($internalCardAuth = null)
    {
        // validation for constraint: boolean
        if (!is_null($internalCardAuth) && !is_bool($internalCardAuth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($internalCardAuth, true), gettype($internalCardAuth)), __LINE__);
        }
        $this->InternalCardAuth = $internalCardAuth;
        return $this;
    }
    /**
     * Get CardPresent value
     * @return bool
     */
    public function getCardPresent()
    {
        return $this->CardPresent;
    }
    /**
     * Set CardPresent value
     * @param bool $cardPresent
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setCardPresent($cardPresent = null)
    {
        // validation for constraint: boolean
        if (!is_null($cardPresent) && !is_bool($cardPresent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cardPresent, true), gettype($cardPresent)), __LINE__);
        }
        $this->CardPresent = $cardPresent;
        return $this;
    }
    /**
     * Get CAVV value
     * @return string|null
     */
    public function getCAVV()
    {
        return $this->CAVV;
    }
    /**
     * Set CAVV value
     * @param string $cAVV
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setCAVV($cAVV = null)
    {
        // validation for constraint: string
        if (!is_null($cAVV) && !is_string($cAVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAVV, true), gettype($cAVV)), __LINE__);
        }
        $this->CAVV = $cAVV;
        return $this;
    }
    /**
     * Get Pares value
     * @return string|null
     */
    public function getPares()
    {
        return $this->Pares;
    }
    /**
     * Set Pares value
     * @param string $pares
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setPares($pares = null)
    {
        // validation for constraint: string
        if (!is_null($pares) && !is_string($pares)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pares, true), gettype($pares)), __LINE__);
        }
        $this->Pares = $pares;
        return $this;
    }
    /**
     * Get MagSupport value
     * @return string|null
     */
    public function getMagSupport()
    {
        return $this->MagSupport;
    }
    /**
     * Set MagSupport value
     * @param string $magSupport
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setMagSupport($magSupport = null)
    {
        // validation for constraint: string
        if (!is_null($magSupport) && !is_string($magSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($magSupport, true), gettype($magSupport)), __LINE__);
        }
        $this->MagSupport = $magSupport;
        return $this;
    }
    /**
     * Get MagStripe value
     * @return string|null
     */
    public function getMagStripe()
    {
        return $this->MagStripe;
    }
    /**
     * Set MagStripe value
     * @param string $magStripe
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setMagStripe($magStripe = null)
    {
        // validation for constraint: string
        if (!is_null($magStripe) && !is_string($magStripe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($magStripe, true), gettype($magStripe)), __LINE__);
        }
        $this->MagStripe = $magStripe;
        return $this;
    }
    /**
     * Get ECI value
     * @return string|null
     */
    public function getECI()
    {
        return $this->ECI;
    }
    /**
     * Set ECI value
     * @param string $eCI
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setECI($eCI = null)
    {
        // validation for constraint: string
        if (!is_null($eCI) && !is_string($eCI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCI, true), gettype($eCI)), __LINE__);
        }
        $this->ECI = $eCI;
        return $this;
    }
    /**
     * Get DUKPT value
     * @return string|null
     */
    public function getDUKPT()
    {
        return $this->DUKPT;
    }
    /**
     * Set DUKPT value
     * @param string $dUKPT
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setDUKPT($dUKPT = null)
    {
        // validation for constraint: string
        if (!is_null($dUKPT) && !is_string($dUKPT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dUKPT, true), gettype($dUKPT)), __LINE__);
        }
        $this->DUKPT = $dUKPT;
        return $this;
    }
    /**
     * Get XID value
     * @return string|null
     */
    public function getXID()
    {
        return $this->XID;
    }
    /**
     * Set XID value
     * @param string $xID
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setXID($xID = null)
    {
        // validation for constraint: string
        if (!is_null($xID) && !is_string($xID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xID, true), gettype($xID)), __LINE__);
        }
        $this->XID = $xID;
        return $this;
    }
    /**
     * Get CardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param string $cardType
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get CardExpiration value
     * @return string|null
     */
    public function getCardExpiration()
    {
        return $this->CardExpiration;
    }
    /**
     * Set CardExpiration value
     * @param string $cardExpiration
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setCardExpiration($cardExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpiration) && !is_string($cardExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpiration, true), gettype($cardExpiration)), __LINE__);
        }
        $this->CardExpiration = $cardExpiration;
        return $this;
    }
    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @param string $cardCode
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get AvsZip value
     * @return string|null
     */
    public function getAvsZip()
    {
        return $this->AvsZip;
    }
    /**
     * Set AvsZip value
     * @param string $avsZip
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setAvsZip($avsZip = null)
    {
        // validation for constraint: string
        if (!is_null($avsZip) && !is_string($avsZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($avsZip, true), gettype($avsZip)), __LINE__);
        }
        $this->AvsZip = $avsZip;
        return $this;
    }
    /**
     * Get AvsStreet value
     * @return string|null
     */
    public function getAvsStreet()
    {
        return $this->AvsStreet;
    }
    /**
     * Set AvsStreet value
     * @param string $avsStreet
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setAvsStreet($avsStreet = null)
    {
        // validation for constraint: string
        if (!is_null($avsStreet) && !is_string($avsStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($avsStreet, true), gettype($avsStreet)), __LINE__);
        }
        $this->AvsStreet = $avsStreet;
        return $this;
    }
    /**
     * Get Signature value
     * @return string|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param string $signature
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: string
        if (!is_null($signature) && !is_string($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signature, true), gettype($signature)), __LINE__);
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Get TermType value
     * @return string|null
     */
    public function getTermType()
    {
        return $this->TermType;
    }
    /**
     * Set TermType value
     * @param string $termType
     * @return \eBizCharge\StructType\CreditCardData
     */
    public function setTermType($termType = null)
    {
        // validation for constraint: string
        if (!is_null($termType) && !is_string($termType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termType, true), gettype($termType)), __LINE__);
        }
        $this->TermType = $termType;
        return $this;
    }
}
