<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://soap.ebizcharge.net/eBizService.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://soap.ebizcharge.net/eBizService.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \eBizCharge\ClassMap::get(),
);
/**
 * Samples for Search ServiceType
 */
$search = new \eBizCharge\ServiceType\Search($options);
/**
 * Sample call for SearchCustomers operation/method
 */
if ($search->SearchCustomers(new \eBizCharge\StructType\SearchCustomers()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchCustomerList operation/method
 */
if ($search->SearchCustomerList(new \eBizCharge\StructType\SearchCustomerList()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchInvoices operation/method
 */
if ($search->SearchInvoices(new \eBizCharge\StructType\SearchInvoices()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchItems operation/method
 */
if ($search->SearchItems(new \eBizCharge\StructType\SearchItems()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchEmailTemplates operation/method
 */
if ($search->SearchEmailTemplates(new \eBizCharge\StructType\SearchEmailTemplates()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchScheduledRecurringPayments operation/method
 */
if ($search->SearchScheduledRecurringPayments(new \eBizCharge\StructType\SearchScheduledRecurringPayments()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchRecurringPayments operation/method
 */
if ($search->SearchRecurringPayments(new \eBizCharge\StructType\SearchRecurringPayments()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchPaymentFormPendingPayments operation/method
 */
if ($search->SearchPaymentFormPendingPayments(new \eBizCharge\StructType\SearchPaymentFormPendingPayments()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchPaymentFormReceivedPayments operation/method
 */
if ($search->SearchPaymentFormReceivedPayments(new \eBizCharge\StructType\SearchPaymentFormReceivedPayments()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchEbizWebFormPendingPayments operation/method
 */
if ($search->SearchEbizWebFormPendingPayments(new \eBizCharge\StructType\SearchEbizWebFormPendingPayments()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchEbizWebFormReceivedPayments operation/method
 */
if ($search->SearchEbizWebFormReceivedPayments(new \eBizCharge\StructType\SearchEbizWebFormReceivedPayments()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchUserList operation/method
 */
if ($search->SearchUserList(new \eBizCharge\StructType\SearchUserList()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchTransactions operation/method
 */
if ($search->SearchTransactions(new \eBizCharge\StructType\SearchTransactions()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchBatches operation/method
 */
if ($search->SearchBatches(new \eBizCharge\StructType\SearchBatches()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchSalesOrders operation/method
 */
if ($search->SearchSalesOrders(new \eBizCharge\StructType\SearchSalesOrders()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchSalesReps operation/method
 */
if ($search->SearchSalesReps(new \eBizCharge\StructType\SearchSalesReps()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchTerms operation/method
 */
if ($search->SearchTerms(new \eBizCharge\StructType\SearchTerms()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchApplicationTransactions operation/method
 */
if ($search->SearchApplicationTransactions(new \eBizCharge\StructType\SearchApplicationTransactions()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchPaymentMethodProfiles operation/method
 */
if ($search->SearchPaymentMethodProfiles(new \eBizCharge\StructType\SearchPaymentMethodProfiles()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchSurchargePayments operation/method
 */
if ($search->SearchSurchargePayments(new \eBizCharge\StructType\SearchSurchargePayments()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \eBizCharge\ServiceType\Add($options);
/**
 * Sample call for AddCustomer operation/method
 */
if ($add->AddCustomer(new \eBizCharge\StructType\AddCustomer()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSubCustomer operation/method
 */
if ($add->AddSubCustomer(new \eBizCharge\StructType\AddSubCustomer()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddInvoice operation/method
 */
if ($add->AddInvoice(new \eBizCharge\StructType\AddInvoice()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddPayment operation/method
 */
if ($add->AddPayment(new \eBizCharge\StructType\AddPayment()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddInvoicePayment operation/method
 */
if ($add->AddInvoicePayment(new \eBizCharge\StructType\AddInvoicePayment()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddItem operation/method
 */
if ($add->AddItem(new \eBizCharge\StructType\AddItem()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUserData operation/method
 */
if ($add->AddUserData(new \eBizCharge\StructType\AddUserData()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddCustomerPaymentMethodProfile operation/method
 */
if ($add->AddCustomerPaymentMethodProfile(new \eBizCharge\StructType\AddCustomerPaymentMethodProfile()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddApplicationData operation/method
 */
if ($add->AddApplicationData(new \eBizCharge\StructType\AddApplicationData()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSalesOrder operation/method
 */
if ($add->AddSalesOrder(new \eBizCharge\StructType\AddSalesOrder()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSalesRep operation/method
 */
if ($add->AddSalesRep(new \eBizCharge\StructType\AddSalesRep()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTerms operation/method
 */
if ($add->AddTerms(new \eBizCharge\StructType\AddTerms()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddApplicationTransaction operation/method
 */
if ($add->AddApplicationTransaction(new \eBizCharge\StructType\AddApplicationTransaction()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \eBizCharge\ServiceType\Update($options);
/**
 * Sample call for UpdateCustomer operation/method
 */
if ($update->UpdateCustomer(new \eBizCharge\StructType\UpdateCustomer()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSubCustomer operation/method
 */
if ($update->UpdateSubCustomer(new \eBizCharge\StructType\UpdateSubCustomer()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateInvoice operation/method
 */
if ($update->UpdateInvoice(new \eBizCharge\StructType\UpdateInvoice()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateItem operation/method
 */
if ($update->UpdateItem(new \eBizCharge\StructType\UpdateItem()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateUserData operation/method
 */
if ($update->UpdateUserData(new \eBizCharge\StructType\UpdateUserData()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateMerchantData operation/method
 */
if ($update->UpdateMerchantData(new \eBizCharge\StructType\UpdateMerchantData()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomerPaymentMethodProfile operation/method
 */
if ($update->UpdateCustomerPaymentMethodProfile(new \eBizCharge\StructType\UpdateCustomerPaymentMethodProfile()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateApplicationData operation/method
 */
if ($update->UpdateApplicationData(new \eBizCharge\StructType\UpdateApplicationData()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSalesOrder operation/method
 */
if ($update->UpdateSalesOrder(new \eBizCharge\StructType\UpdateSalesOrder()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSalesRep operation/method
 */
if ($update->UpdateSalesRep(new \eBizCharge\StructType\UpdateSalesRep()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateTerms operation/method
 */
if ($update->UpdateTerms(new \eBizCharge\StructType\UpdateTerms()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Mark ServiceType
 */
$mark = new \eBizCharge\ServiceType\Mark($options);
/**
 * Sample call for MarkCustomerAsInactive operation/method
 */
if ($mark->MarkCustomerAsInactive(new \eBizCharge\StructType\MarkCustomerAsInactive()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for MarkCustomerAsActive operation/method
 */
if ($mark->MarkCustomerAsActive(new \eBizCharge\StructType\MarkCustomerAsActive()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for MarkCustomerAsSynchronized operation/method
 */
if ($mark->MarkCustomerAsSynchronized(new \eBizCharge\StructType\MarkCustomerAsSynchronized()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for MarkPaymentAsApplied operation/method
 */
if ($mark->MarkPaymentAsApplied(new \eBizCharge\StructType\MarkPaymentAsApplied()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for MarkInvoiceAsSynchronized operation/method
 */
if ($mark->MarkInvoiceAsSynchronized(new \eBizCharge\StructType\MarkInvoiceAsSynchronized()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for MarkRecurringPaymentAsApplied operation/method
 */
if ($mark->MarkRecurringPaymentAsApplied(new \eBizCharge\StructType\MarkRecurringPaymentAsApplied()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for MarkEbizWebFormPaymentAsApplied operation/method
 */
if ($mark->MarkEbizWebFormPaymentAsApplied(new \eBizCharge\StructType\MarkEbizWebFormPaymentAsApplied()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for MarkSalesOrderAsSynchronized operation/method
 */
if ($mark->MarkSalesOrderAsSynchronized(new \eBizCharge\StructType\MarkSalesOrderAsSynchronized()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for MarkApplicationTransactionAsApplied operation/method
 */
if ($mark->MarkApplicationTransactionAsApplied(new \eBizCharge\StructType\MarkApplicationTransactionAsApplied()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for MarkSurchargePaymentAsApplied operation/method
 */
if ($mark->MarkSurchargePaymentAsApplied(new \eBizCharge\StructType\MarkSurchargePaymentAsApplied()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Samples for Copy ServiceType
 */
$copy = new \eBizCharge\ServiceType\Copy($options);
/**
 * Sample call for CopyCustomer operation/method
 */
if ($copy->CopyCustomer(new \eBizCharge\StructType\CopyCustomer()) !== false) {
    print_r($copy->getResult());
} else {
    print_r($copy->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \eBizCharge\ServiceType\Get($options);
/**
 * Sample call for GetCustomer operation/method
 */
if ($get->GetCustomer(new \eBizCharge\StructType\GetCustomer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGWCustomer operation/method
 */
if ($get->GetGWCustomer(new \eBizCharge\StructType\GetGWCustomer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSubCustomer operation/method
 */
if ($get->GetSubCustomer(new \eBizCharge\StructType\GetSubCustomer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoice operation/method
 */
if ($get->GetInvoice(new \eBizCharge\StructType\GetInvoice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPayments operation/method
 */
if ($get->GetPayments(new \eBizCharge\StructType\GetPayments()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPaymentsCount operation/method
 */
if ($get->GetPaymentsCount(new \eBizCharge\StructType\GetPaymentsCount()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoicePayments operation/method
 */
if ($get->GetInvoicePayments(new \eBizCharge\StructType\GetInvoicePayments()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPaymentFormURL operation/method
 */
if ($get->GetPaymentFormURL(new \eBizCharge\StructType\GetPaymentFormURL()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEbizWebFormURL operation/method
 */
if ($get->GetEbizWebFormURL(new \eBizCharge\StructType\GetEbizWebFormURL()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPaymentsByGatewayRefNum operation/method
 */
if ($get->GetPaymentsByGatewayRefNum(new \eBizCharge\StructType\GetPaymentsByGatewayRefNum()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEmailTemplates operation/method
 */
if ($get->GetEmailTemplates(new \eBizCharge\StructType\GetEmailTemplates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMerchantTransactionData operation/method
 */
if ($get->GetMerchantTransactionData(new \eBizCharge\StructType\GetMerchantTransactionData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMerchantTransactionDataBySK operation/method
 */
if ($get->GetMerchantTransactionDataBySK(new \eBizCharge\StructType\GetMerchantTransactionDataBySK()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetScheduledDates operation/method
 */
if ($get->GetScheduledDates(new \eBizCharge\StructType\GetScheduledDates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRecurringSchedulePreview operation/method
 */
if ($get->GetRecurringSchedulePreview(new \eBizCharge\StructType\GetRecurringSchedulePreview()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserData operation/method
 */
if ($get->GetUserData(new \eBizCharge\StructType\GetUserData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMerchantData operation/method
 */
if ($get->GetMerchantData(new \eBizCharge\StructType\GetMerchantData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerToken operation/method
 */
if ($get->GetCustomerToken(new \eBizCharge\StructType\GetCustomerToken()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerPaymentMethodProfiles operation/method
 */
if ($get->GetCustomerPaymentMethodProfiles(new \eBizCharge\StructType\GetCustomerPaymentMethodProfiles()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerPaymentMethodProfile operation/method
 */
if ($get->GetCustomerPaymentMethodProfile(new \eBizCharge\StructType\GetCustomerPaymentMethodProfile()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTransactionDetails operation/method
 */
if ($get->GetTransactionDetails(new \eBizCharge\StructType\GetTransactionDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReceiptsList operation/method
 */
if ($get->GetReceiptsList(new \eBizCharge\StructType\GetReceiptsList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBatchStatus operation/method
 */
if ($get->GetBatchStatus(new \eBizCharge\StructType\GetBatchStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBatchTransactions operation/method
 */
if ($get->GetBatchTransactions(new \eBizCharge\StructType\GetBatchTransactions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetApplicationData operation/method
 */
if ($get->GetApplicationData(new \eBizCharge\StructType\GetApplicationData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSalesOrder operation/method
 */
if ($get->GetSalesOrder(new \eBizCharge\StructType\GetSalesOrder()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSalesRep operation/method
 */
if ($get->GetSalesRep(new \eBizCharge\StructType\GetSalesRep()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTerms operation/method
 */
if ($get->GetTerms(new \eBizCharge\StructType\GetTerms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCardInfo operation/method
 */
if ($get->GetCardInfo(new \eBizCharge\StructType\GetCardInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetZipCodeInfo operation/method
 */
if ($get->GetZipCodeInfo(new \eBizCharge\StructType\GetZipCodeInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReportData operation/method
 */
if ($get->GetReportData(new \eBizCharge\StructType\GetReportData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCardsExpirationList operation/method
 */
if ($get->GetCardsExpirationList(new \eBizCharge\StructType\GetCardsExpirationList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPaymentMethodProfileCounts operation/method
 */
if ($get->GetPaymentMethodProfileCounts(new \eBizCharge\StructType\GetPaymentMethodProfileCounts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRecurringFrequencyList operation/method
 */
if ($get->GetRecurringFrequencyList(new \eBizCharge\StructType\GetRecurringFrequencyList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSurchargeSettings operation/method
 */
if ($get->GetSurchargeSettings(new \eBizCharge\StructType\GetSurchargeSettings()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Authenticate ServiceType
 */
$authenticate = new \eBizCharge\ServiceType\Authenticate($options);
/**
 * Sample call for AuthenticateSK operation/method
 */
if ($authenticate->AuthenticateSK(new \eBizCharge\StructType\AuthenticateSK()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Samples for Schedule ServiceType
 */
$schedule = new \eBizCharge\ServiceType\Schedule($options);
/**
 * Sample call for ScheduleRecurringPayment operation/method
 */
if ($schedule->ScheduleRecurringPayment(new \eBizCharge\StructType\ScheduleRecurringPayment()) !== false) {
    print_r($schedule->getResult());
} else {
    print_r($schedule->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \eBizCharge\ServiceType\Modify($options);
/**
 * Sample call for ModifyScheduledRecurringPaymentStatus operation/method
 */
if ($modify->ModifyScheduledRecurringPaymentStatus(new \eBizCharge\StructType\ModifyScheduledRecurringPaymentStatus()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for ModifyScheduledRecurringPayment_PaymentMethodProfile
 * operation/method
 */
if ($modify->ModifyScheduledRecurringPayment_PaymentMethodProfile(new \eBizCharge\StructType\ModifyScheduledRecurringPayment_PaymentMethodProfile()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for ModifyScheduledRecurringPayment_RecurringBilling
 * operation/method
 */
if ($modify->ModifyScheduledRecurringPayment_RecurringBilling(new \eBizCharge\StructType\ModifyScheduledRecurringPayment_RecurringBilling()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Samples for Resend ServiceType
 */
$resend = new \eBizCharge\ServiceType\Resend($options);
/**
 * Sample call for ResendPaymentFormEmail operation/method
 */
if ($resend->ResendPaymentFormEmail(new \eBizCharge\StructType\ResendPaymentFormEmail()) !== false) {
    print_r($resend->getResult());
} else {
    print_r($resend->getLastError());
}
/**
 * Sample call for ResendEbizWebFormEmail operation/method
 */
if ($resend->ResendEbizWebFormEmail(new \eBizCharge\StructType\ResendEbizWebFormEmail()) !== false) {
    print_r($resend->getResult());
} else {
    print_r($resend->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \eBizCharge\ServiceType\Delete($options);
/**
 * Sample call for DeleteEbizWebFormPayment operation/method
 */
if ($delete->DeleteEbizWebFormPayment(new \eBizCharge\StructType\DeleteEbizWebFormPayment()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteCustomerPaymentMethodProfile operation/method
 */
if ($delete->DeleteCustomerPaymentMethodProfile(new \eBizCharge\StructType\DeleteCustomerPaymentMethodProfile()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \eBizCharge\ServiceType\Login($options);
/**
 * Sample call for Login operation/method
 */
if ($login->Login(new \eBizCharge\StructType\Login()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \eBizCharge\ServiceType\Upload($options);
/**
 * Sample call for UploadAttachment operation/method
 */
if ($upload->UploadAttachment(new \eBizCharge\StructType\UploadAttachment()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \eBizCharge\ServiceType\Set($options);
/**
 * Sample call for SetDefaultCustomerPaymentMethodProfile operation/method
 */
if ($set->SetDefaultCustomerPaymentMethodProfile(new \eBizCharge\StructType\SetDefaultCustomerPaymentMethodProfile()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Run ServiceType
 */
$run = new \eBizCharge\ServiceType\Run($options);
/**
 * Sample call for runTransaction operation/method
 */
if ($run->runTransaction(new \eBizCharge\StructType\RunTransaction()) !== false) {
    print_r($run->getResult());
} else {
    print_r($run->getLastError());
}
/**
 * Sample call for runCustomerTransaction operation/method
 */
if ($run->runCustomerTransaction(new \eBizCharge\StructType\RunCustomerTransaction()) !== false) {
    print_r($run->getResult());
} else {
    print_r($run->getLastError());
}
/**
 * Samples for Email ServiceType
 */
$email = new \eBizCharge\ServiceType\Email($options);
/**
 * Sample call for EmailReceipt operation/method
 */
if ($email->EmailReceipt(new \eBizCharge\StructType\EmailReceipt()) !== false) {
    print_r($email->getResult());
} else {
    print_r($email->getLastError());
}
/**
 * Samples for Render ServiceType
 */
$render = new \eBizCharge\ServiceType\Render($options);
/**
 * Sample call for RenderReceipt operation/method
 */
if ($render->RenderReceipt(new \eBizCharge\StructType\RenderReceipt()) !== false) {
    print_r($render->getResult());
} else {
    print_r($render->getLastError());
}
/**
 * Samples for Close ServiceType
 */
$close = new \eBizCharge\ServiceType\Close($options);
/**
 * Sample call for CloseBatch operation/method
 */
if ($close->CloseBatch(new \eBizCharge\StructType\CloseBatch()) !== false) {
    print_r($close->getResult());
} else {
    print_r($close->getLastError());
}
/**
 * Samples for Calculate ServiceType
 */
$calculate = new \eBizCharge\ServiceType\Calculate($options);
/**
 * Sample call for CalculateSurchargeAmount operation/method
 */
if ($calculate->CalculateSurchargeAmount(new \eBizCharge\StructType\CalculateSurchargeAmount()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
