<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Login StructType
 * @subpackage Structs
 */
class Login extends AbstractStructBase
{
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userId;
    /**
     * The userPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userPassword;
    /**
     * The applicationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $applicationId;
    /**
     * Constructor method for Login
     * @uses Login::setUserId()
     * @uses Login::setUserPassword()
     * @uses Login::setApplicationId()
     * @param string $userId
     * @param string $userPassword
     * @param string $applicationId
     */
    public function __construct($userId = null, $userPassword = null, $applicationId = null)
    {
        $this
            ->setUserId($userId)
            ->setUserPassword($userPassword)
            ->setApplicationId($applicationId);
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \eBizCharge\StructType\Login
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get userPassword value
     * @return string|null
     */
    public function getUserPassword()
    {
        return $this->userPassword;
    }
    /**
     * Set userPassword value
     * @param string $userPassword
     * @return \eBizCharge\StructType\Login
     */
    public function setUserPassword($userPassword = null)
    {
        // validation for constraint: string
        if (!is_null($userPassword) && !is_string($userPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userPassword, true), gettype($userPassword)), __LINE__);
        }
        $this->userPassword = $userPassword;
        return $this;
    }
    /**
     * Get applicationId value
     * @return string|null
     */
    public function getApplicationId()
    {
        return $this->applicationId;
    }
    /**
     * Set applicationId value
     * @param string $applicationId
     * @return \eBizCharge\StructType\Login
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        $this->applicationId = $applicationId;
        return $this;
    }
}
