<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSubCustomer StructType
 * @subpackage Structs
 */
class GetSubCustomer extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerId;
    /**
     * The subCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subCustomerId;
    /**
     * The subCustomerInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subCustomerInternalId;
    /**
     * Constructor method for GetSubCustomer
     * @uses GetSubCustomer::setSecurityToken()
     * @uses GetSubCustomer::setCustomerId()
     * @uses GetSubCustomer::setSubCustomerId()
     * @uses GetSubCustomer::setSubCustomerInternalId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $customerId
     * @param string $subCustomerId
     * @param string $subCustomerInternalId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $customerId = null, $subCustomerId = null, $subCustomerInternalId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setCustomerId($customerId)
            ->setSubCustomerId($subCustomerId)
            ->setSubCustomerInternalId($subCustomerInternalId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\GetSubCustomer
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get customerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param string $customerId
     * @return \eBizCharge\StructType\GetSubCustomer
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get subCustomerId value
     * @return string|null
     */
    public function getSubCustomerId()
    {
        return $this->subCustomerId;
    }
    /**
     * Set subCustomerId value
     * @param string $subCustomerId
     * @return \eBizCharge\StructType\GetSubCustomer
     */
    public function setSubCustomerId($subCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($subCustomerId) && !is_string($subCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCustomerId, true), gettype($subCustomerId)), __LINE__);
        }
        $this->subCustomerId = $subCustomerId;
        return $this;
    }
    /**
     * Get subCustomerInternalId value
     * @return string|null
     */
    public function getSubCustomerInternalId()
    {
        return $this->subCustomerInternalId;
    }
    /**
     * Set subCustomerInternalId value
     * @param string $subCustomerInternalId
     * @return \eBizCharge\StructType\GetSubCustomer
     */
    public function setSubCustomerInternalId($subCustomerInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($subCustomerInternalId) && !is_string($subCustomerInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCustomerInternalId, true), gettype($subCustomerInternalId)), __LINE__);
        }
        $this->subCustomerInternalId = $subCustomerInternalId;
        return $this;
    }
}
