<?php

namespace eBizCharge\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AddCustomer $parameters
     * @return \eBizCharge\StructType\AddCustomerResponse|bool
     */
    public function AddCustomer(\eBizCharge\StructType\AddCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSubCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AddSubCustomer $parameters
     * @return \eBizCharge\StructType\AddSubCustomerResponse|bool
     */
    public function AddSubCustomer(\eBizCharge\StructType\AddSubCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddSubCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AddInvoice $parameters
     * @return \eBizCharge\StructType\AddInvoiceResponse|bool
     */
    public function AddInvoice(\eBizCharge\StructType\AddInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AddPayment $parameters
     * @return \eBizCharge\StructType\AddPaymentResponse|bool
     */
    public function AddPayment(\eBizCharge\StructType\AddPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddInvoicePayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AddInvoicePayment $parameters
     * @return \eBizCharge\StructType\AddInvoicePaymentResponse|bool
     */
    public function AddInvoicePayment(\eBizCharge\StructType\AddInvoicePayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddInvoicePayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AddItem $parameters
     * @return \eBizCharge\StructType\AddItemResponse|bool
     */
    public function AddItem(\eBizCharge\StructType\AddItem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AddUserData $parameters
     * @return \eBizCharge\StructType\AddUserDataResponse|bool
     */
    public function AddUserData(\eBizCharge\StructType\AddUserData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddUserData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddCustomerPaymentMethodProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AddCustomerPaymentMethodProfile $parameters
     * @return \eBizCharge\StructType\AddCustomerPaymentMethodProfileResponse|bool
     */
    public function AddCustomerPaymentMethodProfile(\eBizCharge\StructType\AddCustomerPaymentMethodProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddCustomerPaymentMethodProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddApplicationData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AddApplicationData $parameters
     * @return \eBizCharge\StructType\AddApplicationDataResponse|bool
     */
    public function AddApplicationData(\eBizCharge\StructType\AddApplicationData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddApplicationData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSalesOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AddSalesOrder $parameters
     * @return \eBizCharge\StructType\AddSalesOrderResponse|bool
     */
    public function AddSalesOrder(\eBizCharge\StructType\AddSalesOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddSalesOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSalesRep
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AddSalesRep $parameters
     * @return \eBizCharge\StructType\AddSalesRepResponse|bool
     */
    public function AddSalesRep(\eBizCharge\StructType\AddSalesRep $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddSalesRep($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTerms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AddTerms $parameters
     * @return \eBizCharge\StructType\AddTermsResponse|bool
     */
    public function AddTerms(\eBizCharge\StructType\AddTerms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddTerms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddApplicationTransaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \eBizCharge\StructType\AddApplicationTransaction $parameters
     * @return \eBizCharge\StructType\AddApplicationTransactionResponse|bool
     */
    public function AddApplicationTransaction(\eBizCharge\StructType\AddApplicationTransaction $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddApplicationTransaction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \eBizCharge\StructType\AddApplicationDataResponse|\eBizCharge\StructType\AddApplicationTransactionResponse|\eBizCharge\StructType\AddCustomerPaymentMethodProfileResponse|\eBizCharge\StructType\AddCustomerResponse|\eBizCharge\StructType\AddInvoicePaymentResponse|\eBizCharge\StructType\AddInvoiceResponse|\eBizCharge\StructType\AddItemResponse|\eBizCharge\StructType\AddPaymentResponse|\eBizCharge\StructType\AddSalesOrderResponse|\eBizCharge\StructType\AddSalesRepResponse|\eBizCharge\StructType\AddSubCustomerResponse|\eBizCharge\StructType\AddTermsResponse|\eBizCharge\StructType\AddUserDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
